<?php
// privacy.php - Professional Privacy Policy page (blue/gray theme)
include_once 'config.php';
include_once 'header_view.php';
?>

<style>
    .privacy-container {
        max-width: 900px;
        margin: 120px auto;
        padding: 30px;
        background-color: white;
        box-shadow: 0 6px 15px rgba(0,0,0,0.1);
        border-radius: 12px;
        transition: box-shadow 0.3s ease;
    }
    .privacy-container:hover {
        box-shadow: 0 8px 20px rgba(0,0,0,0.15);
    }
    h2, h3 {
        color: #212529;
        font-family: 'Inter', sans-serif;
    }
    p, li {
        color: #6C757D;
        line-height: 1.7;
    }
</style>

<div class="container privacy-container">
    <h2 class="text-center mb-4"><i class="fas fa-shield-alt me-2"></i>Privacy Policy</h2>
    <h3>1. Introduction</h3>
    <p>At Doyle Enterprise, we value your privacy and are committed to protecting your personal information.</p>
    <h3>2. Information We Collect</h3>
    <p>We collect information you provide during registration, orders, and profile updates, including:</p>
    <ul>
        <li>Username, email, and password.</li>
        <li>Order details and payment information.</li>
    </ul>
    <h3>3. How We Use Your Information</h3>
    <p>Your information is used to process orders, improve our services, and communicate with you.</p>
    <h3>4. Sharing Your Information</h3>
    <p>We do not share your personal information with third parties except as required for order fulfillment or legal compliance.</p>
    <h3>5. Data Security</h3>
    <p>We implement measures to protect your data, but no system is completely secure.</p>
    <h3>6. Your Rights</h3>
    <p>You may access, update, or delete your account information via the profile page.</p>
    <h3>7. Contact Us</h3>
    <p>For privacy concerns, contact us at privacy@doyle.com.</p>
</div>

<?php include_once 'footer.php'; ?>