<?php
// profile.php - User profile page with view/update and order history
include_once 'config.php';
include_once 'auth.php';

// Redirect if not logged in
if (!is_logged_in()) {
    header("Location: login.php?redirect=profile");
    exit();
}

// Handle profile update
if (isset($_POST['update_profile'])) {
    $user_id = $_SESSION['user_id'];
    $username = sanitize_input($_POST['username']);
    $email = sanitize_input($_POST['email']);
    $password = $_POST['password'];
    
    if (update_profile($user_id, $username, $email, $password)) {
        $success = "<div class='alert alert-success'>Profile updated successfully.</div>";
    } else {
        $error = "<div class='alert alert-danger'>Error updating profile: Email or username may already exist.</div>";
    }
}

// Fetch user data
$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT username, email FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

// Fetch order history
$orders = $conn->query("SELECT * FROM orders WHERE user_id = $user_id ORDER BY created_at DESC");

include_once 'header_view.php';
?>

<div class="container admin-container">
    <h2 class="mb-4"><i class="fas fa-user me-2"></i>My Profile</h2>

    <!-- Profile Update Form -->
    <div class="card p-4 mb-4">
        <h4>Update Profile</h4>
        <?php if (isset($success)) echo $success; ?>
        <?php if (isset($error)) echo $error; ?>
        <form method="post">
            <div class="mb-3">
                <label class="form-label">Username</label>
                <input type="text" name="username" class="form-control" required value="<?php echo htmlspecialchars($user['username']); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">Email</label>
                <input type="email" name="email" class="form-control" required value="<?php echo htmlspecialchars($user['email']); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">New Password (leave blank to keep current)</label>
                <input type="password" name="password" class="form-control">
            </div>
            <button type="submit" name="update_profile" class="btn btn-primary" style="background-color: #F15A24; border-color: #F15A24;">Update Profile</button>
        </form>
    </div>

    <!-- Order History -->
    <div class="card p-4">
        <h4>Order History</h4>
        <?php if ($orders->num_rows > 0): ?>
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>Order ID</th>
                        <th>Total</th>
                        <th>Status</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($order = $orders->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($order['id']); ?></td>
                            <td>$<?php echo number_format($order['total'], 2); ?></td>
                            <td><?php echo htmlspecialchars($order['status']); ?></td>
                            <td><?php echo htmlspecialchars($order['created_at']); ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>No orders found.</p>
        <?php endif; ?>
    </div>
</div>

<?php include_once 'footer.php'; ?>