<?php
// register.php - Advanced professional registration page (blue/gray theme)
include_once 'config.php';
include_once 'auth.php';

if (isset($_POST['register'])) {
    $username = sanitize_input($_POST['username']);
    $email = sanitize_input($_POST['email']);
    $password = $_POST['password'];
    if (register($username, $email, $password)) {
        header("Location: login.php");
        exit();
    } else {
        $error = "<div class='alert alert-danger alert-dismissible fade show' role='alert'>Registration failed. Email or username may already exist.<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
    }
}

include_once 'header_view.php';
?>

<style>
    .register-container {
        max-width: 450px;
        margin: 120px auto;
        padding: 30px;
        background-color: white;
        box-shadow: 0 6px 15px rgba(0,0,0,0.1);
        border-radius: 12px;
        transition: box-shadow 0.3s ease;
    }
    .register-container:hover {
        box-shadow: 0 8px 20px rgba(0,0,0,0.15);
    }
    .btn-primary {
        background-color: #0D6EFD;
        border-color: #0D6EFD;
        transition: background-color 0.3s ease, transform 0.2s ease;
    }
    .btn-primary:hover {
        background-color: #0c5fdb;
        transform: translateY(-2px);
    }
    .form-control:focus {
        border-color: #0D6EFD;
        box-shadow: 0 0 5px rgba(13,110,253,0.5);
    }
    .form-label {
        font-weight: 500;
        color: #212529;
    }
    .link-secondary {
        color: #0D6EFD;
        text-decoration: none;
    }
    .link-secondary:hover {
        text-decoration: underline;
    }
</style>

<div class="container register-container">
    <h2 class="text-center mb-4"><i class="fas fa-user-plus me-2"></i>Register</h2>
    <?php if (isset($error)) echo $error; ?>
    <form method="post">
        <div class="mb-3">
            <label class="form-label">Username</label>
            <input type="text" name="username" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Email</label>
            <input type="email" name="email" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Password</label>
            <input type="password" name="password" class="form-control" required>
        </div>
        <button type="submit" name="register" class="btn btn-primary w-100">Register</button>
    </form>
    <p class="text-center mt-3">Already have an account? <a href="login.php" class="link-secondary">Login</a></p>
</div>

<?php include_once 'footer.php'; ?>