<?php
// terms.php - Professional Terms and Conditions page (blue/gray theme)
include_once 'config.php';
include_once 'header_view.php';
?>

<style>
    .terms-container {
        max-width: 900px;
        margin: 120px auto;
        padding: 30px;
        background-color: white;
        box-shadow: 0 6px 15px rgba(0,0,0,0.1);
        border-radius: 12px;
        transition: box-shadow 0.3s ease;
    }
    .terms-container:hover {
        box-shadow: 0 8px 20px rgba(0,0,0,0.15);
    }
    h2, h3 {
        color: #212529;
        font-family: 'Inter', sans-serif;
    }
    p, li {
        color: #6C757D;
        line-height: 1.7;
    }
</style>

<div class="container terms-container">
    <h2 class="text-center mb-4"><i class="fas fa-file-contract me-2"></i>Terms and Conditions</h2>
    <h3>1. Introduction</h3>
    <p>Welcome to Doyle Enterprise. By using our website, you agree to these Terms and Conditions. Please read them carefully.</p>
    <h3>2. Use of the Website</h3>
    <p>You agree to use the website for lawful purposes only and in a manner that does not infringe the rights of others.</p>
    <ul>
        <li>Do not attempt to access unauthorized areas of the website.</li>
        <li>Provide accurate information during registration and purchases.</li>
    </ul>
    <h3>3. Products and Services</h3>
    <p>All products are subject to availability. Prices and descriptions may change without notice.</p>
    <h3>4. Orders and Payments</h3>
    <p>Orders are processed upon payment confirmation. We accept various payment methods as specified at checkout.</p>
    <h3>5. Limitation of Liability</h3>
    <p>Doyle Enterprise is not liable for any indirect or consequential damages arising from the use of our website or products.</p>
    <h3>6. Contact Us</h3>
    <p>If you have questions, contact us at support@doyle.com.</p>
</div>

<?php include_once 'footer.php'; ?>