<?php
// about.php - About Doyle Enterprise
ob_start();
session_start();
include_once 'config.php';
include_once 'auth.php';

// Fallback flash message display
if (!function_exists('display_flash_message')) {
    function display_flash_message() {
        if (isset($_SESSION['flash_message'])) {
            $type = $_SESSION['flash_message']['type'] === 'success' ? 'success' : 'danger';
            $message = htmlspecialchars($_SESSION['flash_message']['message']);
            echo "<div class='alert alert-$type alert-dismissible fade show' role='alert'>
                    $message
                    <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
                  </div>";
            unset($_SESSION['flash_message']);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us - Doyle Enterprise</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .hero-section {
            background: linear-gradient(rgba(0,0,0,0.7), rgba(0,0,0,0.7)), url('images/hero-bg.jpg') center/cover no-repeat;
            color: white;
            padding: 100px 0;
            text-align: center;
        }
        .value-card {
            transition: transform 0.3s;
        }
        .value-card:hover {
            transform: translateY(-10px);
        }
        .mission-vision {
            background-color: #f8f9fa;
            padding: 60px 0;
        }
    </style>
</head>
<body>
    <?php include_once 'header.php'; ?>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <h1 class="display-4 fw-bold">Welcome to Doyle Enterprise</h1>
            <p class="lead">Your Trusted Online Shopping Partner in Kenya</p>
        </div>
    </section>

    <!-- Mission & Vision -->
    <section class="mission-vision">
        <div class="container">
            <div class="row">
                <div class="col-md-6 mb-4">
                    <div class="card h-100 shadow-sm">
                        <div class="card-body text-center">
                            <i class="fas fa-bullseye fa-3x text-primary mb-3"></i>
                            <h3 class="card-title">Our Mission</h3>
                            <p class="card-text">
                                To empower Kenyan consumers with affordable, high-quality products through a secure, user-friendly online platform, fostering trust and convenience in every purchase while supporting local sellers and sustainable growth.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4">
                    <div class="card h-100 shadow-sm">
                        <div class="card-body text-center">
                            <i class="fas fa-eye fa-3x text-success mb-3"></i>
                            <h3 class="card-title">Our Vision</h3>
                            <p class="card-text">
                                To become the leading e-commerce hub in East Africa, revolutionizing online shopping with innovative payment solutions, lightning-fast delivery, and a community-driven marketplace.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Core Values -->
    <section class="py-5">
        <div class="container">
            <h2 class="text-center mb-5">Our Core Values</h2>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="card value-card h-100 text-center border-0 shadow-sm">
                        <div class="card-body">
                            <i class="fas fa-shield-alt fa-2x text-primary mb-3"></i>
                            <h5>Integrity</h5>
                            <p>Transparent, secure, and ethical in all operations.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card value-card h-100 text-center border-0 shadow-sm">
                        <div class="card-body">
                            <i class="fas fa-heart fa-2x text-danger mb-3"></i>
                            <h5>Customer-Centricity</h5>
                            <p>Your satisfaction is our top priority.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card value-card h-100 text-center border-0 shadow-sm">
                        <div class="card-body">
                            <i class="fas fa-lightbulb fa-2x text-warning mb-3"></i>
                            <h5>Innovation</h5>
                            <p>Embracing M-Pesa and modern tech for seamless shopping.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Team / SOP Summary -->
    <section class="bg-light py-5">
        <div class="container">
            <h2 class="text-center mb-5">Standard Operating Procedures (SOPs)</h2>
            <p class="text-center lead mb-5">
                We follow strict SOPs to ensure every order is processed efficiently, securely, and with care.
            </p>
            <div class="row">
                <div class="col-md-6">
                    <ul class="list-group">
                        <li class="list-group-item"><strong>Order Processing:</strong> 3-day delivery guarantee</li>
                        <li class="list-group-item"><strong>Payment Security:</strong> M-Pesa STK Push with rate limiting</li>
                        <li class="list-group-item"><strong>Customer Support:</strong> 24-hour response time</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <ul class="list-group">
                        <li class="list-group-item"><strong>Data Privacy:</strong> GDPR-compliant handling</li>
                        <li class="list-group-item"><strong>Inventory:</strong> Real-time stock updates</li>
                        <li class="list-group-item"><strong>Refunds:</strong> Processed within 48 hours</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <?php include_once 'footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>