<?php
// check_payment_status.php - API endpoint to check order status
header('Content-Type: application/json');
session_start();
include_once 'config.php';

if (!isset($_GET['order_id'])) {
    error_log("check_payment_status: No order_id provided");
    echo json_encode(['status' => 'error', 'message' => 'Invalid order ID']);
    exit();
}

$order_id = intval($_GET['order_id']);
try {
    $stmt = $conn->prepare("SELECT status FROM orders WHERE id = ? AND user_id = ?");
    $stmt->bind_param("ii", $order_id, $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $order = $result->fetch_assoc();
    if (!$order) {
        error_log("check_payment_status: Order not found or access denied for order ID: $order_id");
        echo json_encode(['status' => 'error', 'message' => 'Order not found']);
        exit();
    }
    error_log("check_payment_status: Order #$order_id status = " . $order['status']);
    echo json_encode(['status' => $order['status']]);
} catch (Exception $e) {
    error_log("check_payment_status error: " . $e->getMessage());
    echo json_encode(['status' => 'error', 'message' => 'Server error']);
}
?>