<?php
// config.php - Database connection and helper functions with flash messages
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$servername = "localhost";
$username = "rantovpw_localhost";
$password = "Localhost@2025";
$dbname = "rantovpw_doyle_enterprise";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Helper functions with redeclaration guard
if (!function_exists('is_logged_in')) {
    function is_logged_in() {
        return isset($_SESSION['user_id']);
    }
}

if (!function_exists('is_admin')) {
    function is_admin() {
        return is_logged_in() && isset($_SESSION['is_admin']) && $_SESSION['is_admin'] == 1;
    }
}

if (!function_exists('sanitize_input')) {
    function sanitize_input($data) {
        global $conn;
        return mysqli_real_escape_string($conn, htmlspecialchars(strip_tags($data)));
    }
}

// Flash message functions
if (!function_exists('set_flash_message')) {
    function set_flash_message($type, $message) {
        $_SESSION['flash'][$type][] = $message;
    }
}

if (!function_exists('get_flash_messages')) {
    function get_flash_messages($type) {
        $messages = $_SESSION['flash'][$type] ?? [];
        unset($_SESSION['flash'][$type]);
        return $messages;
    }
}
?>