<?php
// edit_product.php - Edit product (simple form)
session_start();
include 'config.php';
include 'auth.php';
include 'header.php';

if (!is_admin()) {
    header("Location: index.php");
    exit();
}

$id = (int)$_GET['id'];
$stmt = $conn->prepare("SELECT * FROM products WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$row = $stmt->get_result()->fetch_assoc();

if (isset($_POST['update_product'])) {
    $name = sanitize_input($_POST['name']);
    $price = (float)$_POST['price'];
    $description = sanitize_input($_POST['description']);
    $category_id = (int)$_POST['category_id'];
    $stock = (int)$_POST['stock'];
    $image = $_POST['image'];

    $up_stmt = $conn->prepare("UPDATE products SET name=?, price=?, description=?, image=?, category_id=?, stock=? WHERE id=?");
    $up_stmt->bind_param("sdssiii", $name, $price, $description, $image, $category_id, $stock, $id);
    $up_stmt->execute();
    header("Location: admin.php");
    exit();
}

$categories = $conn->query("SELECT * FROM categories");
?>

<h2>Edit Product</h2>
<form method="post">
    <!-- Similar form as add, with values pre-filled -->
    <div class="mb-3">
        <label class="form-label">Name</label>
        <input type="text" name="name" class="form-control" required value="<?php echo $row['name']; ?>">
    </div>
    <!-- ... other fields ... -->
    <button type="submit" name="update_product" class="btn btn-primary">Update</button>
</form>

<?php include 'footer.php'; ?>