<?php ob_start(); session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Help Center & FAQs | Doyle Enterprise Kenya</title>
    <meta name="description" content="Find answers to all your questions about shopping, delivery, payments, returns and more at Doyle Enterprise Kenya.">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary: #ee3425;
            --primary-light: #fff0ef;
            --gray-100: #f8f9fa;
            --gray-200: #e9ecef;
            --gray-700: #495057;
        }
        body {
            font-family: 'Inter', sans-serif;
            background-color: #fff;
            color: #212529;
            line-height: 1.6;
        }
        .jumia-header { background: white; box-shadow: 0 2px 10px rgba(0,0,0,0.08); padding: 1rem 0; position: sticky; top: 0; z-index: 1000; }
        .hero { background: linear-gradient(135deg, #fff0ef 0%, white 70%); padding: 60px 0 80px; text-align: center; }
        .search-bar { max-width: 680px; margin: 0 auto; box-shadow: 0 4px 20px rgba(0,0,0,0.1); border-radius: 12px; overflow: hidden; }
        }
        .search-bar input { border: none; padding: 1.1rem 1.5rem; font-size: 1.1rem; }
        .search-bar button { background: var(--primary); color: white; border: none; padding: 0 2rem; font-weight: 600; }

        .category-tabs .nav-link {
            color: var(--gray-700);
            font-weight: 600;
            padding: 12px 24px;
            border-radius: 50px;
            margin: 0 6px;
            transition: all 0.3s;
        }
        .category-tabs .nav-link.active {
            background: var(--primary);
            color: white;
        }

        .faq-item {
            background: white;
            border: 1px solid var(--gray-200);
            border-radius: 12px;
            margin-bottom: 16px;
            overflow: hidden;
            transition: all 0.3s ease;
        }
        .faq-item:hover {
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
            transform: translateY(-4px);
        }
        .faq-question {
            padding: 1.5rem;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: #fdfdfd;
        }
        .faq-answer {
            padding: 0 1.5rem 1.5rem;
            color: #555;
            border-top: 1px solid var(--gray-200);
            display: none; /* Hidden by default */
        }
        .contact-cta {
            background: var(--primary-light);
            border-radius: 16px;
            padding: 3rem;
            text-align: center;
            margin: 4rem 0;
        }
        .trust-badges img { height: 50px; margin: 0 15px; }

        @media (max-width: 768px) {
            .hero { padding: 50px 0; }
            .search-bar { margin: 0 15px; }
            .category-tabs .nav-link { margin-bottom: 10px; padding: 10px 20px; font-size: 0.95rem; }
        }
    </style>
</head>
<body>

<?php include_once 'header.php'; ?>

<!-- Hero + Search -->
<section class="hero">
    <div class="container">
        <h1 class="display-5 fw-bold mb-3">How can we help you?</h1>
        <p class="lead mb-4">Search our help center or browse popular topics below</p>
        <div class="search-bar d-flex">
            <input type="text" class="form-control" id="faqSearch" placeholder="Search for articles..." aria-label="Search FAQs">
            <button type="button"><i class="fas fa-search"></i></button>
        </div>
    </div>
</section>

<!-- Category Tabs -->
<div class="container my-5">
    <ul class="nav nav-pills category-tabs justify-content-center flex-wrap" id="faqTab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="pills-all-tab" data-bs-toggle="pill" data-bs-target="#pills-all" type="button">All Topics</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="pills-orders-tab" data-bs-toggle="pill" data-bs-target="#pills-orders" type="button">Orders</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="pills-payment-tab" data-bs-toggle="pill" data-bs-target="#pills-payment" type="button">Payment</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="pills-delivery-tab" data-bs-toggle="pill" data-bs-target="#pills-delivery" type="button">Delivery</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="pills-returns-tab" data-bs-toggle="pill" data-bs-target="#pills-returns" type="button">Returns</button>
        </li>
    </ul>
</div>

<!-- Tab Content -->
<div class="container pb-5">
    <div class="tab-content" id="faqTabContent">

        <!-- All Topics Tab -->
        <div class="tab-pane fade show active" id="pills-all" role="tabpanel">
            <div id="faqContainer">
                <!-- All FAQs will be injected here and cloned into other tabs -->
            </div>
        </div>

        <!-- Individual Category Tabs (will be filled by JS) -->
        <div class="tab-pane fade" id="pills-orders" role="tabpanel"></div>
        <div class="tab-pane fade" id="pills-payment" role="tabpanel"></div>
        <div class="tab-pane fade" id="pills-delivery" role="tabpanel"></div>
        <div class="tab-pane fade" id="pills-returns" role="tabpanel"></div>
    </div>

    <!-- Contact CTA -->
    <div class="contact-cta">
        <h3 class="mb-3">Still need help?</h3>
        <p class="lead mb-4">Our support team is available 24/7</p>
        <a href="contact.php" class="btn btn-danger btn-lg px-5 me-3">Contact Support</a>
        <a href="tel:+254746071550" class="btn btn-outline-danger btn-lg">Call Us</a>
    </div>

    <!-- Trust Badges -->
    <div class="text-center py-5">
        <p class="text-muted">Trusted by thousands of customers across Kenya</p>
        <div class="trust-badges">
            <img src="images/ssl.png" alt="SSL Secured">
            <img src="images/mpesa.png" alt="M-Pesa">
            <img src="images/pci.png" alt="PCI DSS">
        </div>
    </div>
</div>

<?php include_once 'footer.php'; ?>

<!-- Bootstrap + Custom JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
// FAQ Data (Central source – no duplication)
const faqData = [
    { question: "How can I place an order?", answer: "<p>Placing an order is easy! Simply browse our website, select the products you want, add them to your cart, and proceed to checkout...</p>", category: "orders" },
    { question: "What payment methods do you accept?", answer: "<p>We accept <strong>M-Pesa (STK Push)</strong>, <strong>Credit/Debit Cards</strong>, and <strong>Cash on Delivery</strong>...</p>", category: "payment" },
    { question: "How long does delivery take?", answer: "<p>Delivery times depend on your location:<ul><li><strong>Nairobi & Mombasa:</strong> 1–3 business days</li>...</ul></p>", category: "delivery" },
    { question: "Do you offer refunds or returns?", answer: "<p>Yes! We offer a <strong>30-day return policy</strong>. Faulty items qualify for free return pickup.</p>", category: "returns" },
    { question: "Is my personal information safe?", answer: "<p>Absolutely. We use <strong>256-bit SSL encryption</strong>, never store card details, and comply with Kenya Data Protection Act.</p>", category: "security" },
    { question: "Can I track my order?", answer: "<p>Yes! Once shipped, you’ll receive a tracking link via SMS and email.</p>", category: "delivery" },
    { question: "What if I receive a damaged product?", answer: "<p>Contact us within 48 hours with photos and we’ll arrange a free replacement or refund.</p>", category: "returns" },
];

// Render FAQs
function renderFAQs(containerId, filterCategory = null) {
    const container = document.getElementById(containerId.replace('#', ''));
    if (!container) return;

    container.innerHTML = ''; // Clear

    faqData.forEach(item => {
        if (filterCategory && item.category !== filterCategory && item.category !== 'security') return; // 'security' only in All

        const faqItem = document.createElement('div');
        faqItem.className = 'faq-item';
        faqItem.setAttribute('data-category', item.category);

        faqItem.innerHTML = `
            <div class="faq-question">
                ${item.question}
                <i class="fas fa-chevron-down"></i>
            </div>
            <div class="faq-answer">
                ${item.answer}
            </div>
        `;
        container.appendChild(faqItem);
    });

    // Re-attach click events for toggle
    attachToggleEvents();
}

// Attach toggle functionality
function attachToggleEvents() {
    document.querySelectorAll('.faq-question').forEach(q => {
        q.onclick = function() {
            const answer = this.nextElementSibling;
            const icon = this.querySelector('i');
            if (answer.style.display === 'block') {
                answer.style.display = 'none';
                icon.classList.replace('fa-chevron-up', 'fa-chevron-down');
            } else {
                answer.style.display = 'block';
                icon.classList.replace('fa-chevron-down', 'fa-chevron-up');
            }
        };
    });
}

// Initial Load: All FAQs in "All Topics"
renderFAQs('#pills-all');

// Fill individual tabs when clicked
const tabButtons = document.querySelectorAll('#faqTab button[data-bs-toggle="pill"]');
tabButtons.forEach(tab => {
    tab.addEventListener('shown.bs.tab', function (e) {
        const target = e.target.getAttribute('data-bs-target');

        if (target === '#pills-all') {
            renderFAQs(target);
        } else {
            const category = target.replace('#pills-', '');
            renderFAQs(target, category);
        }

        // Trigger search again to respect current filter
        document.getElementById('faqSearch').dispatchEvent(new Event('input'));
    });
});

// Live Search (works across active tab only)
document.getElementById('faqSearch').addEventListener('input', function() {
    const term = this.value.toLowerCase();
    const activeTab = document.querySelector('.tab-pane.active');

    activeTab.querySelectorAll('.faq-item').forEach(item => {
        const text = item.textContent.toLowerCase();
        item.style.display = text.includes(term) ? 'block' : 'none';
    });
});

// Load "All" on page load
document.addEventListener('DOMContentLoaded', () => {
    renderFAQs('#pills-all');
});
</script>

</body>
</html>
<?php ob_end_flush(); ?>