<?php
// header_view.php - HTML for sticky navbar with updated categories (blue/gray theme)
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Doyle Enterprise - Online Shopping</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;700&family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <style>
        :root { 
            --primary-blue: #0D6EFD; 
            --secondary-gray: #6C757D; 
            --success-green: #198754; 
            --light-bg: #F8F9FA; 
            --dark-text: #212529; 
        }
        .navbar {
            background-color: white;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            transition: box-shadow 0.3s ease;
        }
        .navbar-brand {
            font-family: 'Inter', sans-serif;
            font-weight: 700;
            color: var(--primary-blue) !important;
        }
        .nav-link {
            font-family: 'Roboto', sans-serif;
            font-weight: 500;
            color: var(--secondary-gray) !important;
            text-decoration: none !important;
            transition: color 0.3s ease;
        }
        .nav-link:hover {
            color: var(--primary-blue) !important;
        }
        .dropdown-item {
            font-family: 'Roboto', sans-serif;
            text-decoration: none !important;
            transition: background-color 0.3s ease;
        }
        .dropdown-item:hover {
            background-color: var(--light-bg);
            color: var(--primary-blue) !important;
        }
        .dropdown-submenu {
            position: relative;
        }
        .dropdown-submenu .dropdown-menu {
            top: 0;
            left: 100%;
            margin-left: .1rem;
            margin-right: .1rem;
        }
        body {
            font-family: 'Roboto', sans-serif;
            background-color: var(--light-bg);
            padding-top: 70px;
        }
        h1, h2, h3 {
            font-family: 'Inter', sans-serif;
            font-weight: 700;
            color: var(--dark-text);
        }
        .card {
            border: none;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 15px rgba(0,0,0,0.15);
        }
        .alert {
            font-family: 'Roboto', sans-serif;
            border-radius: 8px;
            animation: fadeIn 0.5s ease-in;
        }
        .link-secondary {
            color: var(--primary-blue);
            text-decoration: none;
        }
        .link-secondary:hover {
            text-decoration: underline;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="index.php"><i class="fas fa-shopping-bag me-2"></i>Doyle Enterprise</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php"><i class="fas fa-home me-1"></i>Home</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">Categories</a>
                        <ul class="dropdown-menu">
                            <?php
                            $cats = $conn->query("SELECT * FROM categories WHERE parent_id IS NULL");
                            while ($cat = $cats->fetch_assoc()):
                                $subcats = $conn->query("SELECT * FROM categories WHERE parent_id = " . $cat['id']);
                                if ($subcats->num_rows > 0):
                            ?>
                                <li class="dropdown-submenu">
                                    <a class="dropdown-item dropdown-toggle" href="products.php?category=<?php echo $cat['id']; ?>"><?php echo htmlspecialchars($cat['name']); ?></a>
                                    <ul class="dropdown-menu">
                                        <?php while ($subcat = $subcats->fetch_assoc()): ?>
                                            <li><a class="dropdown-item" href="products.php?category=<?php echo $subcat['id']; ?>"><?php echo htmlspecialchars($subcat['name']); ?></a></li>
                                        <?php endwhile; ?>
                                    </ul>
                                </li>
                            <?php else: ?>
                                <li><a class="dropdown-item" href="products.php?category=<?php echo $cat['id']; ?>"><?php echo htmlspecialchars($cat['name']); ?></a></li>
                            <?php endif; ?>
                            <?php endwhile; ?>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="flash_sales.php"><i class="fas fa-fire me-1"></i>Flash Sales</a>
                    </li>
                    <?php if (is_admin()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="admin.php"><i class="fas fa-cog me-1"></i>Admin</a>
                        </li>
                    <?php endif; ?>
                </ul>
                <form class="d-flex me-3" action="products.php" method="get">
                    <input class="form-control me-2" type="search" name="search" placeholder="Search products..." aria-label="Search">
                    <button class="btn btn-outline-primary" type="submit"><i class="fas fa-search"></i></button>
                </form>
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link cart-link" href="cart.php"><i class="fas fa-shopping-cart me-1"></i>Cart <?php echo isset($_SESSION['cart']) ? '(' . array_sum($_SESSION['cart']) . ')' : '(0)'; ?></a>
                    </li>
                    <?php if (is_logged_in()): ?>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"><?php echo htmlspecialchars($_SESSION['username']); ?></a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="profile.php">Profile</a></li>
                                <li><a class="dropdown-item" href="orders.php">My Orders</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                            </ul>
                        </li>
                    <?php else: ?>
                        <li class="nav-item"><a class="nav-link" href="login.php">Login</a></li>
                        <li class="nav-item"><a class="nav-link" href="register.php">Register</a></li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>
    <div class="container mt-4">
        <?php
        // Display flash messages
        foreach (get_flash_messages('success') as $message) {
            echo "<div class='alert alert-success alert-dismissible fade show' role='alert'>$message<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
        }
        foreach (get_flash_messages('error') as $message) {
            echo "<div class='alert alert-danger alert-dismissible fade show' role='alert'>$message<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
        }
        ?>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Enable nested dropdowns
        document.querySelectorAll('.dropdown-submenu').forEach(function(element) {
            element.addEventListener('mouseover', function() {
                let menu = this.querySelector('.dropdown-menu');
                menu.classList.add('show');
            });
            element.addEventListener('mouseout', function() {
                let menu = this.querySelector('.dropdown-menu');
                menu.classList.remove('show');
            });
        });
    </script>
</body>
</html>