<?php
// product.php - Single product page with uniform card and KES prices (blue/gray theme)
session_start();
include_once 'config.php';
include_once 'header.php';

$product_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($product_id <= 0) {
    set_flash_message('error', 'Invalid product ID.');
    header('Location: products.php');
    exit;
}

$result = $conn->query("SELECT p.*, c.name as category FROM products p LEFT JOIN categories c ON p.category_id = c.id WHERE p.id = $product_id");
if ($result->num_rows == 0) {
    set_flash_message('error', 'Product not found.');
    header('Location: products.php');
    exit;
}
$product = $result->fetch_assoc();
?>

<style>
    .product-card {
        width: 200px;
        height: 350px;
        display: flex;
        flex-direction: column;
        overflow: hidden;
        margin: 0 auto;
    }
    .product-card .card-img-top {
        height: 150px;
        object-fit: cover;
        width: 100%;
    }
    .product-card .card-body {
        flex-grow: 1;
        display: flex;
        flex-direction: column;
        padding: 10px;
    }
    .product-card .card-title {
        font-size: 0.9rem;
        margin-bottom: 0.5rem;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    .product-card .card-text {
        font-size: 0.8rem;
        overflow: hidden;
        text-overflow: ellipsis;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
    }
    .product-card .text-primary {
        font-size: 0.9rem;
        margin-bottom: 0.5rem;
    }
    .product-card .btn-sm {
        font-size: 0.8rem;
        padding: 0.3rem;
    }
    .product-details {
        max-width: 600px;
        margin: 0 auto;
    }
</style>

<div class="container mt-5 mb-5">
    <h2 class="text-center mb-4"><?php echo htmlspecialchars($product['name']); ?></h2>
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card product-card">
                <?php if ($product['is_flash_sale']): ?><span class="badge bg-primary position-absolute top-0 start-0 m-2">Flash Sale</span><?php endif; ?>
                <img src="<?php echo $product['image'] ?? 'placeholder.jpg'; ?>" class="card-img-top" alt="<?php echo htmlspecialchars($product['name']); ?>">
                <div class="card-body">
                    <h6 class="card-title"><?php echo htmlspecialchars($product['name']); ?></h6>
                    <p class="card-text"><?php echo htmlspecialchars(substr($product['description'], 0, 60)); ?>...</p>
                    <p class="text-primary fw-bold">KES <?php echo number_format($product['price'], 2); ?></p>
                    <div class="d-grid gap-2">
                        <form method="get" action="cart.php">
                            <input type="hidden" name="action" value="add">
                            <input type="hidden" name="product_id" value="<?php echo $product['id']; ?>">
                            <input type="hidden" name="return_url" value="<?php echo urlencode($_SERVER['REQUEST_URI']); ?>">
                            <button type="submit" class="btn btn-primary btn-sm">Add to Cart</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 product-details">
            <h4>Product Details</h4>
            <p><strong>Category:</strong> <?php echo htmlspecialchars($product['category']); ?></p>
            <p><strong>Description:</strong> <?php echo htmlspecialchars($product['description']); ?></p>
            <p><strong>Price:</strong> KES <?php echo number_format($product['price'], 2); ?></p>
            <p><strong>Stock:</strong> <?php echo $product['stock']; ?> available</p>
            <?php if ($product['is_flash_sale']): ?>
                <p><strong>Flash Sale Discount:</strong> 20% off (Original: KES <?php echo number_format($product['price'] * 1.2, 2); ?>)</p>
            <?php endif; ?>
            <a href="products.php" class="btn btn-outline-primary mt-3">Back to Products</a>
        </div>
    </div>
</div>

<?php include_once 'footer.php'; ?>