<?php
// returns.php - Professional Returns Policy page inspired by Jumia Kenya with logo and PDF download
session_start();
include_once 'config.php';
include_once 'header.php';
?>

<style>
    :root {
        --jumia-orange: #F15A24;
        --bs-primary: #0D6EFD;
    }
    .returns-container {
        max-width: 800px;
        margin: 0 auto;
        padding: 20px;
    }
    .returns-header {
        text-align: center;
        margin-bottom: 30px;
    }
    .returns-header img {
        max-width: 200px;
        height: auto;
    }
    .returns-content {
        background: #fff;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .returns-content:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 15px rgba(0,0,0,0.15);
    }
    .returns-content h2 {
        color: var(--bs-primary);
        font-size: 1.8rem;
        margin-bottom: 20px;
    }
    .returns-content h3 {
        font-size: 1.2rem;
        margin-top: 20px;
        color: #333;
    }
    .returns-content p, .returns-content li {
        font-size: 1rem;
        line-height: 1.6;
        color: #555;
    }
    .returns-content ul {
        padding-left: 20px;
        margin-bottom: 20px;
    }
    .download-btn {
        background-color: var(--jumia-orange);
        border-color: var(--jumia-orange);
        color: #fff;
        font-weight: bold;
        padding: 10px 20px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .download-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 4px 10px rgba(0,0,0,0.2);
    }
</style>

<!-- Returns Policy -->
<section class="returns-container">
    <div class="returns-header">
        <img src="images/moses.png" alt="Doyle Enterprise Logo">
        <h1>Returns Policy</h1>
    </div>
    <div class="returns-content" id="returns-content">
        <h2>Returns Policy</h2>
        <p><strong>Last Updated: October 16, 2025</strong></p>
        <p>At Doyle Enterprise, we want you to be completely satisfied with your purchase. Our Returns Policy outlines the conditions under which you can return products purchased from <a href="http://rantovpw.com/doyle_enterprise">rantovpw.com/doyle_enterprise</a>. Please read this policy carefully before making a purchase.</p>

        <h3>1. Return Eligibility</h3>
        <p>You may return most products within <strong>7 days</strong> from the date of delivery, provided they meet the following conditions:</p>
        <ul>
            <li>The product is unused, in its original condition, and includes all original packaging, tags, and accessories.</li>
            <li>The product is not listed as non-returnable (see Section 2).</li>
            <li>You have proof of purchase (e.g., order confirmation email or receipt).</li>
        </ul>
        <p><strong>Note</strong>: Returns are subject to inspection upon receipt. We reserve the right to refuse returns that do not meet these conditions.</p>

        <h3>2. Non-Returnable Items</h3>
        <p>The following items cannot be returned:</p>
        <ul>
            <li>Hygiene products (e.g., undergarments, swimwear, cosmetics).</li>
            <li>Customized or personalized items.</li>
            <li>Perishable goods or food items.</li>
            <li>Gift cards or digital products.</li>
            <li>Items marked as "Final Sale" at the time of purchase.</li>
        </ul>

        <h3>3. Return Process</h3>
        <p>To initiate a return, follow these steps:</p>
        <ul>
            <li><strong>Contact Us</strong>: Reach out to our customer service team at <a href="mailto:mautimasea14@gmail.com">mautimasea14@gmail.com</a> or +254 123 456 789 within 7 days of delivery to request a return.</li>
            <li><strong>Provide Details</strong>: Include your order number, reason for return, and photos of the product if damaged or incorrect.</li>
            <li><strong>Return Authorization</strong>: We will provide a Return Merchandise Authorization (RMA) number and shipping instructions.</li>
            <li><strong>Ship the Item</strong>: Package the item securely and ship it to the provided address within 7 days of receiving the RMA. Include the RMA number in the package.</li>
        </ul>
        <p><strong>Note</strong>: You are responsible for return shipping costs unless the return is due to our error (e.g., defective or incorrect item).</p>

        <h3>4. Refunds</h3>
        <p>Once we receive and inspect the returned item, we will process your refund within <strong>7-14 business days</strong>. Refunds will be issued to the original payment method and will include the product cost, excluding:</p>
        <ul>
            <li>Shipping fees (unless the return is due to our error).</li>
            <li>Any discounts applied to the original order that no longer apply.</li>
        </ul>
        <p>You will be notified via email once the refund is processed.</p>

        <h3>5. Defective or Incorrect Items</h3>
        <p>If you receive a defective, damaged, or incorrect item, please contact us within <strong>48 hours</strong> of delivery. We will provide a prepaid return label and either replace the item or issue a full refund, including shipping costs.</p>

        <h3>6. Exchanges</h3>
        <p>We do not offer direct exchanges. To exchange an item, return the original product and place a new order for the desired item. Standard return and refund policies apply.</p>

        <h3>7. Cancellations</h3>
        <p>Orders can be canceled before they are shipped. Contact us at <a href="mautimasea14@gmail.com">mautimasea14@gmail.com</a> as soon as possible to request a cancellation. If the order has already shipped, follow the return process.</p>

        <h3>8. International Returns</h3>
        <p>For international orders, contact us to confirm eligibility and return instructions. You are responsible for international return shipping costs, customs fees, and taxes unless the return is due to our error.</p>

        <h3>9. Changes to This Policy</h3>
        <p>We may update this Returns Policy periodically. Changes will be posted on this page, and your continued use of our website constitutes acceptance of the updated policy.</p>

        <h3>10. Contact Us</h3>
        <p>For questions or assistance with returns, contact us at:</p>
        <ul>
            <li>Email: <a href="mailto:mautimasea14@gmail.com">mautimasea14@gmail.com</a></li>
            <li>Phone: +254 123 456 789</li>
            <li>Address: Doyle Enterprise, PO Box 12345, Nairobi, Kenya</li>
        </ul>
    </div>
    <div class="text-center mt-4">
        <button class="btn download-btn" onclick="downloadPDF()">Download as PDF</button>
    </div>
</section>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
<script>
    function downloadPDF() {
        const element = document.getElementById('returns-content');
        const opt = {
            margin: 0.5,
            filename: 'Doyle_Enterprise_Returns_Policy.pdf',
            image: { type: 'jpeg', quality: 0.98 },
            html2canvas: { scale: 2 },
            jsPDF: { unit: 'in', format: 'letter', orientation: 'portrait' }
        };
        html2pdf().from(element).set(opt).save();
    }
</script>

<?php include_once 'footer.php'; ?>