<?php
// terms.php - Professional Terms and Conditions with reliable PDF download
session_start();
include_once 'config.php';
include_once 'header.php';
?>

<style>
    body {
        margin: 0;
        padding: 0;
        background: #f8f9fa;
    }

    :root {
        --jumia-orange: #F15A24;
        --bs-primary: #0D6EFD;
    }

    .terms-container {
        max-width: 900px;
        margin: 40px auto;
        padding: 20px;
    }

    .terms-header {
        text-align: center;
        margin-bottom: 40px;
    }

    .terms-header img {
        max-width: 200px;
        height: auto;
    }

    .terms-content {
        background: #fff;
        padding: 40px 50px;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
    }

    .terms-content h1 {
        text-align: center;
        color: var(--bs-primary);
        font-size: 2.2rem;
        margin: 0 0 20px 0;
    }

    .terms-content h2 {
        text-align: center;
        color: var(--bs-primary);
        font-size: 1.8rem;
        margin: 20px 0 15px 0;
    }

    .terms-content h3 {
        font-size: 1.3rem;
        margin: 30px 0 12px;
        color: #333;
        border-bottom: 1px solid #eee;
        padding-bottom: 8px;
    }

    .terms-content p, .terms-content li {
        font-size: 1.05rem;
        line-height: 1.7;
        color: #444;
        margin-bottom: 14px;
    }

    .terms-content ul {
        padding-left: 30px;
        margin-bottom: 20px;
    }

    .terms-content a {
        color: var(--bs-primary);
        text-decoration: underline;
    }

    .download-btn {
        background-color: var(--jumia-orange);
        border: none;
        color: #fff;
        font-weight: bold;
        font-size: 1.1rem;
        padding: 12px 30px;
        border-radius: 8px;
        cursor: pointer;
        box-shadow: 0 4px 10px rgba(241,90,36,0.3);
        transition: all 0.3s ease;
    }

    .download-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(241,90,36,0.4);
        background-color: #e04e1e;
    }

    @media print {
        .download-btn { display: none !important; }
    }
</style>

<section class="terms-container">
    <div class="terms-header">
        <img src="images/moses.png" alt="Doyle Enterprise Logo" crossorigin="anonymous">
    </div>

    <div class="terms-content" id="terms-content">
        <h1>Terms and Conditions</h1>
        <h2>Terms and Conditions of Use</h2>
        <p style="text-align:center;"><strong>Last Updated: December 16, 2025</strong></p>

        <p>Welcome to Doyle Enterprise ("we," "us," or "our"). These Terms and Conditions ("Terms") govern your use of our website, <a href="http://idealtracking.co.ke/doyle_enterprise">idealtracking.co.ke/doyle_enterprise</a>, and any related services, including online purchases of products such as clothing, accessories, and stationery. By accessing or using our website, you agree to be bound by these Terms. If you do not agree, please do not use our website.</p>

        <h3>1. Acceptance of Terms</h3>
        <p>By using our website, you confirm that you are at least 18 years old or have the consent of a parent or guardian. You agree to comply with these Terms and all applicable laws and regulations.</p>

        <h3>2. Account Registration</h3>
        <p>To make purchases, you may need to create an account. You are responsible for maintaining the confidentiality of your account credentials and for all activities under your account. Notify us immediately of any unauthorized use of your account.</p>

        <h3>3. Orders and Payments</h3>
        <ul>
            <li><strong>Order Acceptance</strong>: All orders are subject to our acceptance. We reserve the right to refuse or cancel any order for reasons including product availability, pricing errors, or suspected fraud.</li>
            <li><strong>Pricing</strong>: Prices are in Kenyan Shillings (KES) and include applicable taxes unless stated otherwise. We may change prices without notice, but the price at the time of order confirmation applies.</li>
            <li><strong>Payment</strong>: We accept payments via methods listed at checkout. You agree to provide accurate payment information and authorize us to charge the full amount, including shipping and taxes.</li>
        </ul>

        <h3>4. Shipping and Delivery</h3>
        <p>We aim to deliver products within the estimated timelines provided at checkout. Delivery times are not guaranteed and may be affected by factors beyond our control. Risk of loss transfers to you upon delivery.</p>

        <h3>5. Returns and Refunds</h3>
        <p>Products may be returned within 7 days of receipt if unused and in original condition, subject to our <a href="returns.php">Returns Policy</a>. Refunds will be processed to the original payment method within 14 days of receiving the returned item.</p>

        <h3>6. Product Descriptions</h3>
        <p>We strive to ensure product descriptions are accurate but do not warrant that they are error-free. Colors and images may vary due to device settings. Contact us for clarification before ordering.</p>

        <h3>7. Intellectual Property</h3>
        <p>All content on our website, including images, text, and logos, is our property or licensed to us and protected by copyright and trademark laws. You may not reproduce, distribute, or use our content without permission.</p>

        <h3>8. User Conduct</h3>
        <p>You agree not to:</p>
        <ul>
            <li>Use the website for unlawful purposes.</li>
            <li>Attempt to access unauthorized areas of the website.</li>
            <li>Post false, misleading, or defamatory content.</li>
        </ul>

        <h3>9. Limitation of Liability</h3>
        <p>To the fullest extent permitted by law, Doyle Enterprise is not liable for any indirect, incidental, or consequential damages arising from your use of the website or products, including loss of data or profits.</p>

        <h3>10. Termination</h3>
        <p>We may suspend or terminate your access to the website if you violate these Terms or engage in conduct we deem harmful to our interests.</p>

        <h3>11. Governing Law</h3>
        <p>These Terms are governed by the laws of Kenya. Any disputes will be resolved in the courts of Nairobi, Kenya.</p>

        <h3>12. Changes to Terms</h3>
        <p>We may update these Terms at any time. Changes will be posted on this page, and your continued use of the website constitutes acceptance of the updated Terms.</p>

        <h3>13. Contact Us</h3>
        <p>For questions or concerns about these Terms, contact us at:</p>
        <ul>
            <li>Email: mautimasea14@gmail.com</li>
            <li>Phone: +254 746 071 550</li>
            <li>Address: Doyle Enterprise, PO Box 12345, Nairobi, Kenya</li>
        </ul>
    </div>

    <div class="text-center mt-4 mb-5">
        <button class="btn download-btn" onclick="downloadPDF()">Download as PDF</button>
    </div>
</section>

<!-- Use stable older version to avoid recent bugs -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.3/html2pdf.bundle.min.js"></script>

<script>
    function downloadPDF() {
        // Hide button
        const btn = document.querySelector('.download-btn');
        const originalDisplay = btn.style.display;
        btn.style.display = 'none';

        // Scroll to top to ensure full capture
        window.scrollTo(0, 0);

        // Create clean wrapper with logo + full content
        const wrapper = document.createElement('div');
        wrapper.style.padding = '40px 50px';
        wrapper.style.background = '#fff';
        wrapper.style.fontFamily = 'Arial, sans-serif';

        // Logo
        const logo = document.querySelector('.terms-header img');
        if (logo) {
            const img = document.createElement('img');
            img.src = logo.src;
            img.style.display = 'block';
            img.style.maxWidth = '200px';
            img.style.margin = '0 auto 40px auto';
            wrapper.appendChild(img);
        }

        // Clone content (remove duplicate h1/h2 if needed)
        const content = document.getElementById('terms-content').cloneNode(true);
        wrapper.appendChild(content);

        const opt = {
            margin: 1,
            filename: 'Doyle_Enterprise_Terms_and_Conditions.pdf',
            image: { type: 'jpeg', quality: 0.98 },
            html2canvas: {
                scale: 2,
                useCORS: true,
                dpi: 192,
                letterRendering: true,
                scrollX: 0,
                scrollY: -window.scrollY // Fix capture position
            },
            jsPDF: {
                unit: 'in',
                format: 'a4',
                orientation: 'portrait'
            }
        };

        html2pdf().from(wrapper).set(opt).save().then(() => {
            btn.style.display = originalDisplay;
        });
    }
</script>

<?php include_once 'footer.php'; ?>