<?php
// Include database connection file
include 'conn.php';

// Initialize variables for success and error messages
$message = "";
$messageClass = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Escape user inputs for security
    $vehicle_reg = mysqli_real_escape_string($conn, $_POST['vehicle_reg']);
    $date_of_installation = mysqli_real_escape_string($conn, $_POST['date_of_installation']);
    $client_name = mysqli_real_escape_string($conn, $_POST['client_name']);
    $sales = mysqli_real_escape_string($conn, $_POST['sales']);
    $model = mysqli_real_escape_string($conn, $_POST['model']);
    $tracker_number = mysqli_real_escape_string($conn, $_POST['tracker_number']);
    $contact = mysqli_real_escape_string($conn, $_POST['contact']);
    $financia = mysqli_real_escape_string($conn, $_POST['financia']);
    $technician = mysqli_real_escape_string($conn, $_POST['technician']);
    $gadget_sample = mysqli_real_escape_string($conn, $_POST['gadget_sample']);
    $Type_of_Gadget = mysqli_real_escape_string($conn, $_POST['Type_of_Gadget']);
    $username = mysqli_real_escape_string($conn, $_POST['username']);
    $password = mysqli_real_escape_string($conn, $_POST['password']);
    $loan_duration = mysqli_real_escape_string($conn, $_POST['loan_duration']);
    $cert_no = mysqli_real_escape_string($conn, $_POST['cert_no']);
    $expiration_date = mysqli_real_escape_string($conn, $_POST['expiration_date']);

    // Check if the vehicle_reg already exists in the database
    $check_query = "SELECT * FROM installrecord WHERE vehicle_reg = '$vehicle_reg'";
    $check_result = mysqli_query($conn, $check_query);

    if (mysqli_num_rows($check_result) > 0) {
        // Duplicate vehicle registration number found
        $message = "Error: Vehicle registration number already exists.";
        $messageClass = "error";
    } else {
        // Insert query
        $sql = "INSERT INTO installrecord (vehicle_reg, date_of_installation, client_name, sales, model, tracker_number, contact, financia, technician, gadget_sample, Type_of_Gadget, username, password, loan_duration, cert_no, expiration_date) 
                VALUES ('$vehicle_reg', '$date_of_installation', '$client_name', '$sales', '$model', '$tracker_number', '$contact', '$financia', '$technician', '$gadget_sample', '$Type_of_Gadget', '$username', '$password', '$loan_duration', '$cert_no', '$expiration_date')";

        if (mysqli_query($conn, $sql)) {
            $message = "Record inserted successfully";
            $messageClass = "success";
        } else {
            $message = "Error: " . $sql . "<br>" . mysqli_error($conn);
            $messageClass = "error";
        }
    }
}

// Fetch salespersons
$salespersons_query = "SELECT name FROM salespersons";
$salespersons_result = mysqli_query($conn, $salespersons_query);
$salespersons = [];
while ($row = mysqli_fetch_assoc($salespersons_result)) {
    $salespersons[] = $row['name'];
}

// Fetch technicians
$technicians_query = "SELECT name FROM technicians";
$technicians_result = mysqli_query($conn, $technicians_query);
$technicians = [];
while ($row = mysqli_fetch_assoc($technicians_result)) {
    $technicians[] = $row['name'];
}

// Close connection
mysqli_close($conn);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation Record</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f8ff;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .container {
            background-color: #e6f7ff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 800px;
            width: 100%;
            box-sizing: border-box;
            margin-top: 30px;
        }
        h2 {
            color: #007acc;
            text-align: center;
            margin-bottom: 20px;
        }
        form {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }
        .form-group {
            display: flex;
            flex-direction: column;
            width: calc(50% - 20px);
        }
        label {
            color: #007acc;
            margin-bottom: 5px;
        }
        input[type="text"], input[type="date"], input[type="number"], input[type="password"], select {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-sizing: border-box;
        }
        .full-width {
            width: 100%;
        }
        button {
            width: 100%;
            padding: 10px;
            background-color: #007acc;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover {
            background-color: #005fa3;
        }
        .message {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            padding: 20px;
            background-color: #dff0d8; /* Success message background color */
            border: 1px solid #3c763d; /* Success message border color */
            color: #3c763d; /* Success message text color */
            border-radius: 5px;
            display: none; /* Initially hidden */
            z-index: 9999; /* Ensure it's on top */
        }
        .message.error {
            background-color: #f2dede; /* Error message background color */
            border-color: #a94442; /* Error message border color */
            color: #a94442; /* Error message text color */
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var messageElement = document.querySelector('.message');

            <?php if (!empty($message)) { ?>
                showMessage('<?php echo $message; ?>', '<?php echo $messageClass; ?>');
            <?php } ?>

            function showMessage(message, className) {
                messageElement.textContent = message;
                messageElement.classList.add(className);
                messageElement.style.display = 'block';
                setTimeout(function() {
                    messageElement.style.display = 'none';
                    messageElement.classList.remove(className);
                }, 4000); // Disappear after 4 seconds
            }
        });
    </script>
</head>
<body>
    <div class="container">
        <h2>Add Installation Record</h2>
        <form method="post" action="add.php">
            <div class="form-group">
                <label for="vehicle_reg">Vehicle Registration</label>
                <input type="text" id="vehicle_reg" name="vehicle_reg" required>
            </div>
            <div class="form-group">
                <label for="date_of_installation">Date of Installation</label>
                <input type="date" id="date_of_installation" name="date_of_installation" required>
            </div>
            <div class="form-group">
                <label for="client_name">Client Name</label>
                <input type="text" id="client_name" name="client_name" required>
            </div>
            <div class="form-group">
                <label for="sales">Sales</label>
                <select id="sales" name="sales" required>
                    <option value="">Select Sales Person</option>
                    <?php foreach ($salespersons as $salesperson): ?>
                        <option value="<?php echo $salesperson; ?>"><?php echo $salesperson; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="model">Model</label>
                <input type="text" id="model" name="model" required>
            </div>
            <div class="form-group">
                <label for="tracker_number">Tracker Number</label>
                <input type="text" id="tracker_number" name="tracker_number" required>
            </div>
            <div class="form-group">
                <label for="contact">Contact</label>
                <input type="text" id="contact" name="contact" required>
            </div>
            <div class="form-group">
                <label for="financia">Financia</label>
                <input type="text" id="financia" name="financia" required>
            </div>
            <div class="form-group">
                <label for="technician">Technician</label>
                <select id="technician" name="technician" required>
                    <option value="">Select Technician</option>
                    <?php foreach ($technicians as $technician): ?>
                        <option value="<?php echo $technician; ?>"><?php echo $technician; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="gadget_sample">Gadget Sample</label>
                <input type="text" id="gadget_sample" name="gadget_sample" required>
            </div>
            <div class="form-group">
                <label for="Type_of_Gadget">Type of Gadget</label>
                <input type="text" id="Type_of_Gadget" name="Type_of_Gadget" required>
            </div>
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" >
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" >
            </div>
            <div class="form-group">
                <label for="loan_duration">Loan Duration</label>
                <input type="text" id="loan_duration" name="loan_duration" >
            </div>
            <div class="form-group">
                <label for="cert_no">Certificate Number</label>
                <input type="text" id="cert_no" name="cert_no" >
            </div>
            <div class="form-group">
                <label for="expiration_date">Expiration Date</label>
                <input type="date" id="expiration_date" name="expiration_date" >
            </div>
            <div class="form-group full-width">
                <button type="submit">Submit</button>
            </div>
        </form>
    </div>
    <div class="message <?php echo $messageClass; ?>"><?php echo $message; ?></div>
</body>
</html>
