<?php
// Include the database connection
include 'conn.php';

// Path to the file where the last download date will be stored
$last_backup_file = 'last_backup.txt';

// Function to format the date
function formatDate($timestamp) {
    return date('jS F Y', strtotime($timestamp));
}

// Prepare file name with a human-readable date format
$backup_date = formatDate(date('Y-m-d'));
$backup_file = 'finemark_database_backup_of_' . $backup_date . '.sql';
$temp_file = '/tmp/' . $backup_file;

// Open file for writing
$file_handle = fopen($temp_file, 'w');

if ($file_handle === false) {
    die('Error: Unable to open file for writing.');
}

// Function to write SQL queries to file
function writeQuery($query, $file_handle) {
    fwrite($file_handle, $query . ";\n\n");
}

// Get the list of tables
$tables = [];
$result = $conn->query('SHOW TABLES');
if ($result) {
    while ($row = $result->fetch_array()) {
        $tables[] = $row[0];
    }
}

// Loop through tables and write their structure and data
foreach ($tables as $table) {
    // Get table creation statement
    $result = $conn->query("SHOW CREATE TABLE `$table`");
    if ($result) {
        $createTable = $result->fetch_assoc();
        writeQuery($createTable['Create Table'], $file_handle);
    }

    // Get table data
    $result = $conn->query("SELECT * FROM `$table`");
    if ($result) {
        $rows = $result->fetch_all(MYSQLI_ASSOC);
        foreach ($rows as $row) {
            $values = array_map([$conn, 'real_escape_string'], array_values($row));
            writeQuery("INSERT INTO `$table` VALUES ('" . implode("', '", $values) . "')", $file_handle);
        }
    }
}

// Close the file handle
fclose($file_handle);

// If the request is to download the backup file, handle the download
if (isset($_GET['download']) && file_exists($temp_file)) {
    // Record the current date and time as the last download date
    file_put_contents($last_backup_file, date('Y-m-d H:i:s'));

    header('Content-Description: File Transfer');
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="' . basename($temp_file) . '"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($temp_file));

    // Read the file and output it to the user
    readfile($temp_file);

    // Clean up
    unlink($temp_file);
    exit;
}

// Read the last download date from the file, if it exists
$last_download_date = file_exists($last_backup_file) ? file_get_contents($last_backup_file) : 'Never';

// Display HTML for user interface
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Database Backup</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #e9ecef;
        }
        .container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            text-align: center;
            width: 90%;
            max-width: 500px;
        }
        h1 {
            margin-bottom: 20px;
            font-size: 24px;
            color: #333;
        }
        p {
            font-size: 16px;
            color: #555;
        }
        button {
            background-color: #007bff;
            color: #fff;
            border: none;
            padding: 12px 25px;
            font-size: 18px;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            margin: 10px;
        }
        button:hover {
            background-color: #0056b3;
        }
        .icon {
            font-size: 50px;
            color: #007bff;
            margin-bottom: 20px;
        }
        .message {
            display: none;
            margin-top: 20px;
            font-size: 18px;
            color: #28a745;
        }
    </style>
</head>
<body>
    <div class="container">
        <i class="fas fa-database icon"></i>
        <h1>Download Database Backup</h1>
        <p>Click the button below to download the latest database backup.</p>
        <p><strong>Last Backup Download:</strong> <?= formatDate($last_download_date) ?></p>
        <a href="?download=1" id="downloadLink">
            <button>Download Backup</button>
        </a>
        <p class="message" id="successMessage">Your database backup has been downloaded. You can now store it in a secure place.</p>
        <a href="dashboard.php">
            <button>Return to Home</button>
        </a>
    </div>

    <script>
        document.getElementById('downloadLink').addEventListener('click', function() {
            setTimeout(function() {
                document.getElementById('successMessage').style.display = 'block';
            }, 500); // delay for the file download to start
        });
    </script>
</body>
</html>
