<?php
require 'vendor/autoload.php';

use PhpOffice\PhpWord\TemplateProcessor;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if the file was uploaded without errors
    if (isset($_FILES['template']['tmp_name']) && $_FILES['template']['error'] === UPLOAD_ERR_OK) {
        $uploadedFile = $_FILES['template']['tmp_name'];
        $numberOfCertificates = intval($_POST['number']);
        $templateFileName = $_FILES['template']['name'];
        
        // Define the path to save the generated certificates
        $outputDirectory = 'certificate';
        
        // Ensure the output directory exists
        if (!is_dir($outputDirectory)) {
            mkdir($outputDirectory, 0777, true);
        }
        
        // Generate certificates
        $generatedFiles = [];
        for ($i = 1; $i <= $numberOfCertificates; $i++) {
            $templateProcessor = new TemplateProcessor($uploadedFile);
            $templateProcessor->setValue('SERIAL_NUMBER', $i);
            
            $outputFileName = $outputDirectory . "/certificate_{$i}.docx";
            $templateProcessor->saveAs($outputFileName);
            $generatedFiles[] = $outputFileName;
        }
        
        // Zip the generated certificates for download
        $zip = new ZipArchive();
        $zipFileName = 'certificates.zip';
        
        if ($zip->open($zipFileName, ZipArchive::CREATE) === TRUE) {
            foreach ($generatedFiles as $file) {
                $zip->addFile($file, basename($file));
            }
            $zip->close();
            
            // Download the zip file
            header('Content-Type: application/zip');
            header('Content-Disposition: attachment; filename="' . $zipFileName . '"');
            header('Content-Length: ' . filesize($zipFileName));
            readfile($zipFileName);
            
            // Clean up
            unlink($zipFileName);
            array_map('unlink', $generatedFiles);
        } else {
            echo 'Failed to create zip file.';
        }
        exit;
    } else {
        echo 'Error uploading the file.';
    }
} else {
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Generate Certificates</title>
    </head>
    <body>
        <form action="" method="post" enctype="multipart/form-data">
            <label for="template">Upload Template (.docx):</label>
            <input type="file" id="template" name="template" accept=".docx" required><br><br>
            
            <label for="number">Number of Certificates:</label>
            <input type="number" id="number" name="number" min="1" required><br><br>
            
            <input type="submit" value="Generate and Download">
        </form>
    </body>
    </html>
    <?php
}
?>