<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include the database connection
include 'conn.php';

// Function to convert date format
function formatDate($date) {
    return date('m/d/Y', strtotime($date));
}

// Function to convert date format back for SQL
function formatDateForSQL($date) {
    return date('Y-m-d', strtotime($date));
}

// Redirect function to prevent form resubmission
function redirect($url) {
    header("Location: $url");
    exit();
}

// Function to dynamically bind parameters
function bind_params($stmt, $types, ...$params) {
    $bind_names[] = $types;
    for ($i = 0; $i < count($params); $i++) {
        $bind_names[] = &$params[$i];
    }
    
    call_user_func_array([$stmt, 'bind_param'], $bind_names);
}

// Insert record
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['insert'])) {
    $date = formatDateForSQL($_POST['date']);
    $technician_name = $_POST['technician'];
    $assigned_by = $_POST['assigned_by'];
    $reg_no = $_POST['reg_no'];
    $revenue = $_POST['revenue'];
    $cost = $_POST['cost'];
    $status_comment = $_POST['status_comment'];
    $paid = isset($_POST['paid']) ? 1 : 0;

    // Insert record
    $sql = "INSERT INTO checkups (DATE, TECHNICIAN, Assigned_by, REG_NO, REVENUE, COST, STATUS_COMMENT, Paid) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);

    if ($stmt === false) {
        die('Prepare failed: ' . htmlspecialchars($conn->error));
    }

    bind_params($stmt, 'ssssddsi', $date, $technician_name, $assigned_by, $reg_no, $revenue, $cost, $status_comment, $paid);

    if (!$stmt->execute()) {
        die('Execute failed: ' . htmlspecialchars($stmt->error));
    }

    // Redirect to avoid resubmission
    redirect('checkups.php');
}

// Delete record
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $sql = "DELETE FROM checkups WHERE id = ?";
    $stmt = $conn->prepare($sql);

    if ($stmt === false) {
        die('Prepare failed: ' . htmlspecialchars($conn->error));
    }

    $stmt->bind_param('i', $id);

    if (!$stmt->execute()) {
        die('Execute failed: ' . htmlspecialchars($stmt->error));
    }

    redirect('checkups.php');
}

// Edit record
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit'])) {
    $id = $_POST['id'];
    $date = formatDateForSQL($_POST['date']);
    $technician_name = $_POST['technician'];
    $assigned_by = $_POST['assigned_by'];
    $reg_no = $_POST['reg_no'];
    $revenue = $_POST['revenue'];
    $cost = $_POST['cost'];
    $status_comment = $_POST['status_comment'];
    $paid = isset($_POST['paid']) ? 1 : 0;

    $sql = "UPDATE checkups SET DATE = ?, TECHNICIAN = ?, Assigned_by = ?, REG_NO = ?, REVENUE = ?, COST = ?, STATUS_COMMENT = ?, Paid = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);

    if ($stmt === false) {
        die('Prepare failed: ' . htmlspecialchars($conn->error));
    }

    bind_params($stmt, 'ssssddsi', $date, $technician_name, $assigned_by, $reg_no, $revenue, $cost, $status_comment, $paid, $id);

    if (!$stmt->execute()) {
        die('Execute failed: ' . htmlspecialchars($stmt->error));
    }

    redirect('checkups.php');
}

// Fetch technicians for dropdown
$tech_sql = "SELECT full_name FROM technician"; // Adjust the table name and column if necessary
$tech_result = $conn->query($tech_sql);

// Fetch users for assigned_by dropdown
$user_sql = "SELECT full_name FROM users";
$user_result = $conn->query($user_sql);

// Search record
$search = '';
$tech_filter = '';
$start_date = '';
$end_date = '';

if (isset($_GET['search']) || isset($_GET['filter'])) {
    $search = $_GET['search'] ?? '';
    $tech_filter = $_GET['technician'] ?? '';
    $start_date = $_GET['start_date'] ?? '';
    $end_date = $_GET['end_date'] ?? '';

    $sql = "SELECT * FROM checkups WHERE 1=1";
    $types = ''; // Type string for bind_param
    $params = []; // Array to hold parameters

    if ($search) {
        $sql .= " AND REG_NO LIKE ?";
        $types .= 's';
        $params[] = "%$search%";
    }
    if ($tech_filter) {
        $sql .= " AND TECHNICIAN = ?";
        $types .= 's';
        $params[] = $tech_filter;
    }
    if ($start_date && $end_date) {
        $sql .= " AND DATE BETWEEN ? AND ?";
        $types .= 'ss';
        $params[] = $start_date;
        $params[] = $end_date;
    }

    $stmt = $conn->prepare($sql);

    if ($stmt === false) {
        die('Prepare failed: ' . htmlspecialchars($conn->error));
    }

    if ($types) {
        bind_params($stmt, $types, ...$params);
    }

    if (!$stmt->execute()) {
        die('Execute failed: ' . htmlspecialchars($stmt->error));
    }

    $result = $stmt->get_result();
} else {
    $sql = "SELECT * FROM checkups";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $result = $stmt->get_result();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Checkups</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/5.3.0/css/bootstrap.min.css">
    <style>
        /* Basic Reset */
      /* Basic Reset */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

/* Body */
body {
    font-family: Arial, sans-serif;
    background-color: #f4f4f4;
    color: #333;
}

/* Container */
.container {
    width: 95%;

    margin: 20px auto;
    padding: 20px;
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    display: flex;
    flex-direction: column;
    gap: 20px;
}

/* Header */
h1 {
    color: #333;
    text-align: center;
    margin-bottom: 20px;
}

/* Return Button */
.return-button {
    display: inline-block;
    padding: 10px 15px;
    background-color: #007bff;
    color: #fff;
    text-decoration: none;
    border-radius: 5px;
    font-size: 16px;
    align-self: flex-start;
}

.return-button:hover {
    background-color: #0056b3;
}

.return-button i {
    margin-right: 5px;
}

/* Form Container */
.form-container,
.search-container {
    gap: 15px;
}

.form-container {
    background-color: #e9ecef;
    padding: 20px;
    border-radius: 8px;
}

.search-container {
    background-color: #f1f1f1;
    padding: 15px;
    border-radius: 8px;
}

form {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
    text-align: center;
    justify-content: space-between;
}

.form-group {
    flex: 1;
    min-width: 200px;
}

.form-group label {
    font-weight: bold;
    color: #007bff;
}

.form-group input[type="text"],
.form-group input[type="date"],
.form-group input[type="number"],
.form-group select,
.form-group textarea {
    width: 100%;
    padding: 8px;
    border: 1px solid #ccc;
    border-radius: 4px;
}

.form-group textarea {
    resize: vertical;
}

.form-group input[type="checkbox"] {
    margin-right: 5px;
    align-self: center;
}

button {
    background-color: #007bff;
    color: #fff;
    border: none;
    padding: 10px 20px;
    border-radius: 4px;
    font-size: 16px;
    cursor: pointer;
}

button:hover {
    background-color: #0056b3;
}

/* Table */
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
}

th, td {
    border: 1px solid #ddd;
    padding: 10px;
    text-align: left;
}

th {
    background-color: #007bff;
    color: #fff;
}

tr:nth-child(even) {
    background-color: #f2f2f2;
}

tr:hover {
    background-color: #ddd;
}

.actions a {
    margin-right: 10px;
    text-decoration: none;
    color: #007bff;
}

.actions a:hover {
    text-decoration: underline;
}

.delete {
    color: red;
}

.delete:hover {
    text-decoration: underline;
}

/* Responsive Design */
@media (max-width: 768px) {
    .container {
        width: 95%;
        padding: 15px;
    }

    .form-container,
    .search-container {
        padding: 10px;
    }

    form {
        flex-direction: column;
        align-items: center;
    }

    .form-group {
        width: 100%;
        margin-bottom: 15px;
    }
}

@media (max-width: 480px) {
    .return-button {
        font-size: 14px;
        padding: 8px 12px;
    }

    button {
        font-size: 14px;
        padding: 8px 12px;
    }
}

    </style>
</head>
<body>
    <div class="container">
        <a href="dashboard.php" class="return-button"><i class="fas fa-arrow-left"></i> Return to Main Menu</a>

        <h1>Manage Checkups</h1>

        <div class="form-container">
            <form action="checkups.php" method="POST">
                <input type="hidden" name="id" value="<?php echo isset($_GET['edit']) ? htmlspecialchars($_GET['edit']) : ''; ?>">
                <div class="form-group">
                    <label for="date">Date:</label>
                    <input type="date" id="date" name="date" required value="<?php echo isset($_GET['edit']) ? htmlspecialchars($row['DATE']) : ''; ?>">
                </div>
                <div class="form-group">
                    <label for="technician">Technician:</label>
                    <select id="technician" name="technician" required>
                        <?php while ($tech_row = $tech_result->fetch_assoc()) : ?>
                            <option value="<?php echo htmlspecialchars($tech_row['full_name']); ?>"
                                <?php echo isset($_GET['edit']) && htmlspecialchars($tech_row['full_name']) == htmlspecialchars($row['TECHNICIAN']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($tech_row['full_name']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="assigned_by">Assigned By:</label>
                    <select id="assigned_by" name="assigned_by" required>
                        <?php while ($user_row = $user_result->fetch_assoc()) : ?>
                            <option value="<?php echo htmlspecialchars($user_row['full_name']); ?>"
                                <?php echo isset($_GET['edit']) && htmlspecialchars($user_row['full_name']) == htmlspecialchars($row['Assigned_by']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($user_row['full_name']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="reg_no">Registration No:</label>
                    <input type="text" id="reg_no" name="reg_no" required value="<?php echo isset($_GET['edit']) ? htmlspecialchars($row['REG_NO']) : ''; ?>">
                </div>
                <div class="form-group">
                    <label for="revenue">Revenue:</label>
                    <input type="number" id="revenue" name="revenue" step="0.01"  value="<?php echo isset($_GET['edit']) ? htmlspecialchars($row['REVENUE']) : ''; ?>">
                </div>
                <div class="form-group">
                    <label for="cost">Cost:</label>
                    <input type="number" id="cost" name="cost" step="0.01" value="<?php echo isset($_GET['edit']) ? htmlspecialchars($row['COST']) : ''; ?>">
                </div>
                <div class="form-group">
                    <label for="status_comment">Status Comment:</label>
                    <textarea id="status_comment" name="status_comment"><?php echo isset($_GET['edit']) ? htmlspecialchars($row['STATUS_COMMENT']) : ''; ?></textarea>
                </div>
               
                <button type="submit" name="<?php echo isset($_GET['edit']) ? 'edit' : 'insert'; ?>">
                    <?php echo isset($_GET['edit']) ? 'Update Record' : 'Add Record'; ?>
                </button>
            </form>
        </div>

        <div class="search-container">
            <form action="checkups.php" method="GET">
                <div class="form-group">
                    <label for="search">Search by REG_NO:</label>
                    <input type="text" id="search" name="search" value="<?php echo htmlspecialchars($search); ?>">
                </div>
                <div class="form-group">
                    <label for="technician">Technician:</label>
                    <select id="technician" name="technician">
                        <option value="">Select Technician</option>
                        <?php while ($tech_row = $tech_result->fetch_assoc()) : ?>
                            <option value="<?php echo htmlspecialchars($tech_row['full_name']); ?>"
                                <?php echo $tech_filter == htmlspecialchars($tech_row['full_name']) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($tech_row['full_name']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="start_date">Start Date:</label>
                    <input type="date" id="start_date" name="start_date" value="<?php echo htmlspecialchars($start_date); ?>">
                </div>
                <div class="form-group">
                    <label for="end_date">End Date:</label>
                    <input type="date" id="end_date" name="end_date" value="<?php echo htmlspecialchars($end_date); ?>">
                </div>
                <button type="submit" name="search">Search</button>
            </form>
        </div>

        <table>
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Technician</th>
                    <th>Assigned By</th>
                    <th>Registration No</th>
                    <th>Revenue</th>
                    <th>Cost</th>
                    <th>Status Comment</th>
                    <th>Paid</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_assoc()) : ?>
                    <tr>
                        <td><?php echo formatDate($row['DATE']); ?></td>
                        <td><?php echo htmlspecialchars($row['TECHNICIAN']); ?></td>
                        <td><?php echo htmlspecialchars($row['Assigned_by']); ?></td>
                        <td><?php echo htmlspecialchars($row['REG_NO']); ?></td>
                        <td><?php echo number_format($row['REVENUE'], 2); ?></td>
                        <td><?php echo number_format($row['COST'], 2); ?></td>
                        <td><?php echo htmlspecialchars($row['STATUS_COMMENT']); ?></td>
                        <td><?php echo $row['Paid'] ? 'Yes' : 'No'; ?></td>
                        <td class="actions">
                      
                            <a href="checkups.php?delete=<?php echo urlencode($row['id']); ?>" class="delete" onclick="return confirm('Are you sure you want to delete this record?');">Delete</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>
</body>
</html>
