<?php
// confirmation.php

// Retrieve POST data from the callback
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Log the received data (optional)
file_put_contents('callback_log.txt', print_r($data, true), FILE_APPEND);

// Process the response
if (isset($data['Body']['stkCallback'])) {
    $callback = $data['Body']['stkCallback'];

    // Check the result code
    $resultCode = $callback['ResultCode'];
    $resultDesc = $callback['ResultDesc'];

    if ($resultCode == 0) {
        // Payment successful
        $transactionId = $callback['CallbackMetadata']['Item'][1]['Value'];
        $amount = $callback['CallbackMetadata']['Item'][0]['Value'];
        $phoneNumber = $callback['CallbackMetadata']['Item'][4]['Value'];

        // You can store these details in your database or perform other actions
        file_put_contents('success_log.txt', "Transaction ID: $transactionId\nAmount: $amount\nPhone Number: $phoneNumber\n", FILE_APPEND);

        // Respond with a success message
        echo "Payment successful. Thank you!";
    } else {
        // Payment failed
        file_put_contents('failure_log.txt', "Error: $resultDesc\n", FILE_APPEND);

        // Respond with a failure message
        echo "Payment failed: $resultDesc";
    }
} else {
    // Handle cases where 'stkCallback' is not set
    file_put_contents('error_log.txt', "Callback data missing.\n", FILE_APPEND);

    echo "Invalid callback data.";
}
?>
