<?php
// Database connection parameters
$dbHost = 'localhost';
$dbName = 'rantovpw_idealtrackrecord';
$dbUser = 'rantovpw_idealtrack';
$dbPass = 'P?YjNx%N[XGp';

// Connect to the database
try {
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Function to convert date format from dd/mm/yyyy or dd/mm/yy to mm/dd/yyyy
function convertDateFormat($date) {
    // Check if the date is in dd/mm/yyyy format
    $dateObj = DateTime::createFromFormat('d/m/Y', $date);
    if ($dateObj && $dateObj->format('Y') > 1000) {
        return $dateObj->format('m/d/Y');
    }

    // Check if the date is in dd/mm/yy format and convert the year to yyyy
    $dateObj = DateTime::createFromFormat('d/m/y', $date);
    if ($dateObj) {
        $year = $dateObj->format('y');
        // Assume all two-digit years are in the 2000s
        if ($year < 100) {
            $year += 2000;
        }
        $dateObj->setDate($year, $dateObj->format('m'), $dateObj->format('d'));
        return $dateObj->format('m/d/Y');
    }

    // Return null if the date format is not recognized
    return null;
}

// Query to select all columns from your table
$sql = "SELECT INSTALLATION_DATE, CLIENT_NAME, SALES_PERSON, VEHICLE_REG, MODEL, TRACKER_NUMBER, CONTACT, Finacia, TECHNICIAN, T_K, Tracksolid, USERNAME, PASSWORD, LOAN_DURATION, C_NO FROM record10";

try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $records = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Output headers for Excel
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="record_data.xls"');

    // Start Excel table
    echo '<table border="1">';
    echo '<tr>';
    echo '<th>INSTALLATION_DATE</th>';
    echo '<th>CLIENT_NAME</th>';
    echo '<th>SALES_PERSON</th>';
    echo '<th>VEHICLE_REG</th>';
    echo '<th>MODEL</th>';
    echo '<th>TRACKER_NUMBER</th>';
    echo '<th>CONTACT</th>';
    echo '<th>Finacia</th>';
    echo '<th>TECHNICIAN</th>';
    echo '<th>T_K</th>';
    echo '<th>Tracksolid</th>';
    echo '<th>USERNAME</th>';
    echo '<th>PASSWORD</th>';
    echo '<th>LOAN_DURATION</th>';
    echo '<th>C_NO</th>';
    echo '<th>expiray</th>';
    echo '</tr>';

    // Loop through each record, convert date format, calculate expiry date, and output in Excel table format
    foreach ($records as $record) {
        $installationDate = $record['INSTALLATION_DATE'];
        $convertedDate = convertDateFormat($installationDate);

        // Skip records with invalid dates
        if ($convertedDate === null) {
            continue;
        }

        // Calculate the expiry date (example: add 365 days)
        $installationDateObj = DateTime::createFromFormat('m/d/Y', $convertedDate);
        $expirayDate = $installationDateObj->add(new DateInterval('P365D'))->format('m/d/Y');

        echo '<tr>';
        echo '<td>' . htmlspecialchars($convertedDate) . '</td>';
        echo '<td>' . htmlspecialchars($record['CLIENT_NAME']) . '</td>';
        echo '<td>' . htmlspecialchars($record['SALES_PERSON']) . '</td>';
        echo '<td>' . htmlspecialchars($record['VEHICLE_REG']) . '</td>';
        echo '<td>' . htmlspecialchars($record['MODEL']) . '</td>';
        echo '<td>' . htmlspecialchars($record['TRACKER_NUMBER']) . '</td>';
        echo '<td>' . htmlspecialchars($record['CONTACT']) . '</td>';
        echo '<td>' . htmlspecialchars($record['Finacia']) . '</td>';
        echo '<td>' . htmlspecialchars($record['TECHNICIAN']) . '</td>';
        echo '<td>' . htmlspecialchars($record['T_K']) . '</td>';
        echo '<td>' . htmlspecialchars($record['Tracksolid']) . '</td>';
        echo '<td>' . htmlspecialchars($record['USERNAME']) . '</td>';
        echo '<td>' . htmlspecialchars($record['PASSWORD']) . '</td>';
        echo '<td>' . htmlspecialchars($record['LOAN_DURATION']) . '</td>';
        echo '<td>' . htmlspecialchars($record['C_NO']) . '</td>';
        echo '<td>' . htmlspecialchars($expirayDate) . '</td>';
        echo '</tr>';
    }

    // End Excel table
    echo '</table>';

} catch (PDOException $e) {
    die("Error retrieving records: " . $e->getMessage());
}

// Close the connection
$pdo = null;
?>
