<?php
// Error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include your database connection file
include 'conn.php'; 

// Initialize variables
$records = [];
$selected_record = null;
$search_criteria = 'VEHICLE_REG'; // Default search criteria

// Handle search
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['search'])) {
    $search_value = $_POST['search_value'];
    $search_criteria = $_POST['search_criteria'];
    
    // Fetch records based on search criteria
    $sql = "SELECT * FROM record10 WHERE $search_criteria = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        die('Prepare failed: ' . $conn->error);
    }
    $stmt->bind_param("s", $search_value);
    $stmt->execute();
    $result = $stmt->get_result();
    $records = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}

// Handle selection of a record for editing
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['edit_record'])) {
    $selected_value = $_POST['selected_value'];
    $search_criteria = $_POST['search_criteria'];
    
    // Fetch the selected record
    $sql = "SELECT * FROM record10 WHERE $search_criteria = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        die('Prepare failed: ' . $conn->error);
    }
    $stmt->bind_param("s", $selected_value);
    $stmt->execute();
    $result = $stmt->get_result();
    $selected_record = $result->fetch_assoc();
    $stmt->close();
}

// Handle update
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update'])) {
    $original_value = $_POST['original_value']; // Original value for identifying record
    $search_criteria = $_POST['search_criteria']; // Criteria used for searching

    // Construct the SQL query dynamically based on which fields are provided
    $update_fields = [];
    $params = [];
    $types = '';

    $fields = [
        'INSTALLATION_DATE',
        'CLIENT_NAME',
        'SALES_PERSON',
        'VEHICLE_REG',
        'MODEL',
        'TRACKER_NUMBER',
        'CONTACT',
        'Bank',
        'TECHNICIAN',
        'T_K',
        'Tracksolid',
        'USERNAME',
        'PASSWORD',
        'LOAN_DURATION',
        'C_NO',
        'expiray'
    ];

    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            $update_fields[] = "$field = ?";
            $params[] = $_POST[$field];
            $types .= 's'; // Assuming all fields are strings
        }
    }

    if (!empty($update_fields)) {
        // If search criteria or value is being updated, adjust the query and parameters
        $where_clause = "WHERE $search_criteria = ?";
        $params[] = $original_value;
        $types .= 's';

        $sql = "UPDATE record10 SET " . implode(", ", $update_fields) . " " . $where_clause;
        
        $stmt = $conn->prepare($sql);
        if ($stmt === false) {
            die('Prepare failed: ' . $conn->error);
        }

        // Bind parameters
        $stmt->bind_param($types, ...$params);
        $stmt->execute();

        if ($stmt->error) {
            die('Execute failed: ' . $stmt->error);
        }

        $stmt->close();
        echo "<p class='success-message'>Record updated successfully.</p>";
        // Clear selected record after update
        $selected_record = null;
    } else {
        echo "<p class='warning-message'>No fields were updated.</p>";
    }
}

// Close connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Record</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            color: #333;
        }
        .container {
            width: 90%;
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            background: #fff;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            border-radius: 8px;
        }
        h1 {
            text-align: center;
            color: #007bff;
            font-size: 2em;
            margin-bottom: 20px;
        }
        form {
            display: flex;
            flex-direction: column;
        }
        label {
            margin: 10px 0 5px;
            font-weight: bold;
            color: #007bff;
        }
        input[type="text"], select {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            margin-bottom: 10px;
            font-size: 16px;
        }
        input[type="submit"] {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        input[type="submit"]:hover {
            background-color: #0056b3;
        }
        select {
            background-color: #e9ecef;
            border-color: #ced4da;
        }
        select:focus {
            border-color: #007bff;
            box-shadow: 0 0 0 0.2rem rgba(38, 143, 255, 0.25);
        }
        .icon {
            font-size: 1.2em;
            margin-right: 10px;
        }
        .form-group {
            display: flex;
            align-items: center;
        }
        .form-group label {
            flex: 1;
        }
        .form-group input, .form-group select {
            flex: 2;
        }
        @media (max-width: 768px) {
            .form-group {
                flex-direction: column;
            }
            .form-group label,
            .form-group input, .form-group select {
                flex: none;
                width: 100%;
            }
        }
        .success-message {
            color: #28a745;
            font-weight: bold;
            text-align: center;
        }
        .warning-message {
            color: #dc3545;
            font-weight: bold;
            text-align: center;
        }
        a {
            display: inline-block;
            padding: 8px 15px;
            margin: 10px;
            font-size: 14px;
            text-decoration: none;
            color: #fff;
            background-color: #6c757d;
            border-radius: 5px;
            text-align: center;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            transition: background-color 0.3s ease;
        }
        a:hover {
            background-color: #5a6268;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Edit Record</h1>
        
        <!-- Search Form -->
        <form method="POST">
            <div class="form-group">
                <label for="search_criteria"><i class="fas fa-search icon"></i> Search By:</label>
                <select name="search_criteria" required>
                  
                    <option value="ID" <?php echo $search_criteria === 'ID' ? 'selected' : ''; ?>>ID</option>
                    <!-- Add more criteria as needed -->
                </select>
            </div>
            <div class="form-group">
                <label for="search_value"><i class="fas fa-search icon"></i> Enter Search Value:</label>
                <input type="text" name="search_value" value="<?php echo htmlspecialchars($_POST['search_value'] ?? ''); ?>">
            </div>
            <input type="submit" name="search" value="Search">
            <a href="dashboard.php">Return To Dashboard</a>
        </form>
        
        <!-- Records List -->
        <?php if (!empty($records)): ?>
            <?php if (count($records) > 1): ?>
                <p class='warning-message'>Multiple records found. Please refine your search using ID for precise results.</p>
            <?php else: ?>
                <h2>Select Record to Edit</h2>
                <form method="POST">
                    <input type="hidden" name="search_criteria" value="<?php echo htmlspecialchars($search_criteria); ?>">
                    <select name="selected_value" required>
                        <option value="">Select a record</option>
                        <?php foreach ($records as $rec): ?>
                            <option value="<?php echo htmlspecialchars($rec[$search_criteria]); ?>" <?php echo ($selected_record && $rec[$search_criteria] == $selected_record[$search_criteria]) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($rec['VEHICLE_REG'] . ' - ' . $rec['TRACKER_NUMBER']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <input type="submit" name="edit_record" value="Edit Record">
                </form>
            <?php endif; ?>
        <?php endif; ?>

        <!-- Edit Form -->
        <?php if ($selected_record): ?>
            <h2>Edit Record</h2>
            <form method="POST">
                <input type="hidden" name="search_criteria" value="<?php echo htmlspecialchars($search_criteria); ?>">
                <input type="hidden" name="original_value" value="<?php echo htmlspecialchars($selected_record[$search_criteria]); ?>">
                
                <?php foreach ($selected_record as $key => $value): ?>
                    <?php if ($key !== $search_criteria): ?>
                        <div class="form-group">
                            <label for="<?php echo $key; ?>"><i class="fas fa-edit icon"></i> <?php echo htmlspecialchars($key); ?>:</label>
                            <input type="text" name="<?php echo $key; ?>" id="<?php echo $key; ?>" value="<?php echo htmlspecialchars($value); ?>">
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
                
                <input type="submit" name="update" value="Update Record">
            </form>
        <?php endif; ?>
    </div>
</body>
</html>
