<?php
// Include the session check
include 'session_check.php'; 
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>IDT SYSTEM</title>
      <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: blueviolet;
            color: #333;
            padding: 0;
            margin: 0;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            padding:15px;
        }

        h2 {
            text-align: center;
            color: #fff;
            margin-bottom: 30px;
        }

       /* Form Container Styles */
form {
    margin: 4px auto;
    background-color: rgba(255, 255, 255, 0.9);
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    width: 100%;
    max-width: 95vw; /* Increased max-width for better utilization of space */
    box-sizing: border-box;
    display:flex;
    flex-wrap:wrap;
    gap:20px;
}

/* Form Group Styles */
.form-group {
    display: flex;
    flex-direction: column;
    margin-bottom: 15px;
}

.form-group label {
    margin-bottom: 5px;
    color: #004e92;
    font-weight: bold; /* Bold labels for a formal appearance */
}

.form-group input, .form-group select {
    padding: 10px;
    border-radius: 4px;
    border: 1px solid #004e92;
    width: 400px;
    box-sizing: border-box;
    font-size: 16px; /* Adjust font size for readability */
}

/* Form Actions Styles */
.form-actions {
    display: flex;
    flex-direction: column;
    gap: 15px; /* Space between buttons */
    margin-top: 20px;
}

input[type="submit"], .return-button {
    padding: 12px 20px;
    border-radius: 4px;
    text-align: center;
    cursor: pointer;
    transition: background-color 0.3s ease;
    font-size: 16px; /* Consistent font size for buttons */
}

input[type="submit"] {
    background-color: #007bff;
    color: #fff;
    border: none;
}

input[type="submit"]:hover {
    background-color: #0056b3;
}

.return-button {
    background-color: brown;
    color: #fff;
    text-decoration: none;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.return-button:hover {
    background-color: darkred;
}

/* Responsive Styles */
@media (max-width: 768px) {
   
    .form-group {
        margin-bottom: 20px;
    }

    .form-actions {
        flex-direction: column;
    }

    input[type="submit"], .return-button {
        width: 100%;
    }
}

@media (max-width: 480px) {
    h2 {
        font-size: 20px;
        margin-bottom: 20px;
    }

    form {
        padding: 15px;
        width: 95%;
    }

    .form-group label {
        font-size: 14px;
    }

    .form-group input, .form-group select {
        font-size: 14px;
        padding: 12px;
    }

    input[type="submit"], .return-button {
        font-size: 14px;
        padding: 14px;
    }
}
        input[type="submit"] {
            padding: 8px 15px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        input[type="submit"]:hover {
            background-color: #0056b3;
        }

        .table-container {
            width: 100%;
            height: calc(100vh - 200px); /* Adjust the height to fit within the viewport */
            overflow: auto;
            position: relative;
            background-color: #fff;
            border-top: 1px solid #ddd;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
            font-size: 12px;
        }

        th, td {
            padding: 8px 10px;
            text-align: left;
            border: 1px solid #ddd;
            white-space: nowrap; /* Prevent text wrapping */
        }

        thead th {
            position: -webkit-sticky;
            position: sticky;
            top: 0;
            background-color: #f9f9f9;
            z-index: 10;
        }

        .expired {
            background-color: #B22222;
            color: black;
        }

        .active {
            background-color: white; /* Green for active */
            color: black;
        }

        .no-loan-duration {
            background-color:#ADD8E6; /* Light red background for zero or empty loan duration */
            color: black; /* Dark red text for contrast */
        }

        .print-button {
            margin-top: 20px;
            display: block;
            width: 200px;
            padding: 8px;
            font-size: 14px;
            text-align: center;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .print-button:hover {
            background-color: #0056b3;
        }

        .column-selector {
            margin-bottom: 20px;
        }

        .column-selector label {
            display: block;
            margin-bottom: 5px;
        }

        @media print {
            body {
                margin: 0;
            }

            body > *:not(.table-container) {
                display: none;
            }

            .print-button {
                display: none;
            }

            .column-selector {
                display: none;
            }

            .table-container {
                height: auto;
                margin: 0;
            }

            table {
                width: 100%;
                border-collapse: collapse;
                background-color: transparent !important;
                color: black !important;
                page-break-inside: auto;
                font-size: 10px;
            }

            thead {
                display: table-header-group;
            }

            tbody {
                display: table-row-group;
            }

            tr {
                page-break-inside: auto;
                page-break-after: auto;
            }

            th, td {
                padding: 5px;
            }
        }

        @media (max-width: 768px) {
            .form-group {
                flex-basis: 100%;
                flex-direction: column;
                align-items: flex-start;
            }
            .form-group label {
                text-align: left;
                flex-basis: 100%;
            }
            .form-group input, .form-group select {
                flex-basis: 100%;
            }
        }
        .bg-green {
    background-color: green;
    color: white; /* Optional: change text color to contrast with green background */
}

    </style>
    <script>
        function toggleColumn(columnIndex, isChecked) {
            const table = document.querySelector('table');
            const rows = table.querySelectorAll('tr');
            rows.forEach(row => {
                const cells = row.querySelectorAll('td, th');
                if (cells[columnIndex]) {
                    cells[columnIndex].style.display = isChecked ? '' : 'none';
                }
            });
        }

        function updateColumns() {
            const checkboxes = document.querySelectorAll('.column-selector input[type="checkbox"]');
            checkboxes.forEach((checkbox, index) => {
                toggleColumn(index, checkbox.checked);
            });
        }

        function handlePrint() {
            updateColumns(); // Ensure columns are updated before print
            window.print();
        }

        document.addEventListener('DOMContentLoaded', () => {
            const checkboxes = document.querySelectorAll('.column-selector input[type="checkbox"]');
            checkboxes.forEach(checkbox => {
                checkbox.addEventListener('change', updateColumns);
            });
            document.querySelector('.print-button').addEventListener('click', handlePrint);
        });
          function exportToExcel() {
            const table = document.querySelector('table');
            const visibleColumns = Array.from(table.querySelectorAll('th')).map(th => th.style.display !== 'none');

            // Create a new table for export
            const exportTable = document.createElement('table');
            const thead = document.createElement('thead');
            const tbody = document.createElement('tbody');
            
            // Add headers
            const headerRow = document.createElement('tr');
            table.querySelectorAll('thead th').forEach((th, index) => {
                if (visibleColumns[index]) {
                    const headerCell = document.createElement('th');
                    headerCell.textContent = th.textContent;
                    headerRow.appendChild(headerCell);
                }
            });
            thead.appendChild(headerRow);
            exportTable.appendChild(thead);

            // Add rows
            table.querySelectorAll('tbody tr').forEach(row => {
                const exportRow = document.createElement('tr');
                row.querySelectorAll('td').forEach((td, index) => {
                    if (visibleColumns[index]) {
                        const exportCell = document.createElement('td');
                        exportCell.textContent = td.textContent;
                        exportRow.appendChild(exportCell);
                    }
                });
                tbody.appendChild(exportRow);
            });
            exportTable.appendChild(tbody);

            // Export to Excel
            const wb = XLSX.utils.table_to_book(exportTable);
            XLSX.writeFile(wb, 'report.xlsx');
        }

        document.addEventListener('DOMContentLoaded', () => {
            const checkboxes = document.querySelectorAll('.column-selector input[type="checkbox"]');
            checkboxes.forEach(checkbox => {
                checkbox.addEventListener('change', updateColumns);
            });
            document.querySelector('.print-button').addEventListener('click', handlePrint);
            document.querySelector('.export-button').addEventListener('click', exportToExcel);
        });
    </script>
</head>
<body>
    <h2>Ideal Tracking, Trackers Record</h2>

    <form action="<?php echo $_SERVER["PHP_SELF"]; ?>" method="post">
        <div class="form-group">
    <label for="salesPerson">Sales Person:</label>
    <select id="salesPerson" name="salesPerson">
        <option value="">Select Sales Person</option>
        <?php
        // Database connection details
        $dbHost = 'localhost';
        $dbName = 'rantovpw_idealtrackrecord';
        $dbUser = 'rantovpw_idealtrack';
        $dbPass = 'P?YjNx%N[XGp';

        // Connect to the database
        $conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);

        // Check connection
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // Fetch sales persons in alphabetical order
        $salesPersonQuery = "SELECT DISTINCT SALES_PERSON FROM record10 ORDER BY SALES_PERSON ASC";
        $salesPersonResult = $conn->query($salesPersonQuery);

        // Check if the query was successful
        if ($salesPersonResult === false) {
            die("Error in query: " . $conn->error);
        }

        // Check if there are results and output options
        if ($salesPersonResult->num_rows > 0) {
            while($row = $salesPersonResult->fetch_assoc()) {
                // Ensure data is properly escaped
                $salesPersonName = htmlspecialchars($row['SALES_PERSON']);
                echo "<option value=\"$salesPersonName\">$salesPersonName</option>";
            }
        } else {
            echo '<option value="">No sales persons found</option>';
        }

        // Close the connection
        $conn->close();
        ?>
    </select>
    </div>

       <div class="form-group">
    <label for="technician">Technician:</label>
    <select id="technician" name="technician">
        <option value="">Select Technician</option>
        <?php
        // Database connection details
        $dbHost = 'localhost';
        $dbName = 'rantovpw_idealtrackrecord';
        $dbUser = 'rantovpw_idealtrack';
        $dbPass = 'P?YjNx%N[XGp';

        // Connect to the database
        $conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);

        // Check connection
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // Fetch technicians in ascending order (A to Z)
        $technicianQuery = "SELECT DISTINCT TECHNICIAN FROM record10 ORDER BY TECHNICIAN ASC";
        $technicianResult = $conn->query($technicianQuery);

        // Check if the query was successful
        if ($technicianResult === false) {
            die("Error in query: " . $conn->error);
        }

        // Check if there are results and output options
        if ($technicianResult->num_rows > 0) {
            while ($row = $technicianResult->fetch_assoc()) {
                // Ensure data is properly escaped
                $technicianName = htmlspecialchars($row['TECHNICIAN']);
                echo "<option value=\"$technicianName\">$technicianName</option>";
            }
        } else {
            echo '<option value="">No technicians found</option>';
        }

        // Close the connection
        $conn->close();
        ?>
    </select>
    </div>



        
        <div class="form-group">
            <label for="startDate">Installation Start Date:</label>
            <input type="date" id="startDate" name="startDate">
        
            <label for="endDate">End Date:</label>
            <input type="date" id="endDate" name="endDate">
        </div>
        <div class="form-group">
            <label for="startExpirayDate">Start Expiray Date:</label>
            <input type="date" id="startExpirayDate" name="startExpirayDate">
            
            <label for="endExpirayDate">End Expiray Date:</label>
            <input type="date" id="endExpirayDate" name="endExpirayDate">
        </div>

        <div class="form-group">
            <label for="clientName">Client Name:</label>
            <input type="text" id="clientName" name="clientName">
        </div>
        <div class="form-group">
            <label for="bank">Bank:</label>
            <input type="text" id="bank" name="bank">
        </div>
        <div class="form-group">
            <label for="vehicleReg">Vehicle Registration:</label>
            <input type="text" id="vehicleReg" name="vehicleReg">
        </div>
        <div class="form-group">
        <label for="contact">Contact:</label>
        <input type="text" id="contact" name="contact">
    </div>
    <div class="form-group">
        <label for="trackerNumber">Tracker Number:</label>
        <input type="text" id="trackerNumber" name="trackerNumber">
    </div>
    
    <div class="form-group">
        <input type="submit" value="Search Record">
     </div>
    <div class="form-group">
     
     <a href="dashboard.php" style="display: inline-block; padding: 8px 15px; font-size: 14px; text-decoration: none; color: #fff; background-color: brown; border-radius: 5px; text-align:margin-top:20px; center; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); transition: background-color 0.3s ease;">Return To Dashboard</a>
    </div> 
    <div style="margin-top: 10px; padding: 8px 12px; border: 1px solid #ddd; border-radius: 4px; background-color: #f9f9f9; font-size: 12px;">
    <h4 style="margin-top: 0; margin-bottom: 5px;">User Manual</h4>
    <p style="margin: 5px 0;"><strong>Loan Duration:</strong> <span style="display: inline-block; width: 15px; height: 15px; background-color: brown; border-radius: 3px; vertical-align: middle; margin-right: 5px;"></span> Indicates the vehicle is renewed.</p>
    <p style="margin: 5px 0;"><strong>Technician:</strong> <span style="display: inline-block; width: 15px; height: 15px; background-color: green; border-radius: 3px; vertical-align: middle; margin-right: 5px;"></span> Indicates the technician has been paid for that installation.</p>
</div>
          
    </form>
<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $dbHost = 'localhost';
    $dbName = 'rantovpw_idealtrackrecord';
    $dbUser = 'rantovpw_idealtrack';
    $dbPass = 'P?YjNx%N[XGp';

    // Connect to the database
    $conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);

    // Check connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    $conditions = [];

    // Existing conditions...
    if (!empty($_POST['salesPerson'])) {
        $salesPerson = sanitize($_POST['salesPerson'], $conn);
        $conditions[] = "SALES_PERSON = '$salesPerson'";
    }
    if (!empty($_POST['technician'])) {
        $technician = sanitize($_POST['technician'], $conn);
        $conditions[] = "TECHNICIAN = '$technician'";
    }
    if (!empty($_POST['startDate']) && !empty($_POST['endDate'])) {
        $startDate = formatDate($_POST['startDate']);
        $endDate = formatDate($_POST['endDate']);
        $conditions[] = "STR_TO_DATE(INSTALLATION_DATE, '%m/%d/%Y') BETWEEN STR_TO_DATE('$startDate', '%m/%d/%Y') AND STR_TO_DATE('$endDate', '%m/%d/%Y')";
    }
    if (!empty($_POST['startExpirayDate']) && !empty($_POST['endExpirayDate'])) {
        $startExpirayDate = formatDate($_POST['startExpirayDate']);
        $endExpirayDate = formatDate($_POST['endExpirayDate']);
        $conditions[] = "STR_TO_DATE(expiray, '%m/%d/%Y') BETWEEN STR_TO_DATE('$startExpirayDate', '%m/%d/%Y') AND STR_TO_DATE('$endExpirayDate', '%m/%d/%Y')";
    }
    if (!empty($_POST['clientName'])) {
        $clientName = sanitize($_POST['clientName'], $conn);
        $conditions[] = "CLIENT_NAME LIKE '%$clientName%'";
    }
    if (!empty($_POST['bank'])) {
        $bank = sanitize($_POST['bank'], $conn);
        $conditions[] = "Bank LIKE '%$bank%'";
    }
    if (!empty($_POST['vehicleReg'])) {
        $vehicleReg = sanitize($_POST['vehicleReg'], $conn);
        $conditions[] = "VEHICLE_REG LIKE '%$vehicleReg%'";
    }
    if (!empty($_POST['contact'])) {
        $contact = sanitize($_POST['contact'], $conn);
        $conditions[] = "CONTACT LIKE '%$contact%'";
    }
    if (!empty($_POST['trackerNumber'])) {
        $trackerNumber = sanitize($_POST['trackerNumber'], $conn);
        $conditions[] = "TRACKER_NUMBER LIKE '%$trackerNumber%'";
    }
    
    // Add conditions for the new fields
    if (!empty($_POST['bankBranch'])) {
        $bankBranch = sanitize($_POST['bankBranch'], $conn);
        $conditions[] = "Bank_Branch LIKE '%$bankBranch%'";
    }
    if (!empty($_POST['trackerLocation'])) {
        $trackerLocation = sanitize($_POST['trackerLocation'], $conn);
        $conditions[] = "Tracker_Location LIKE '%$trackerLocation%'";
    }

    // SQL query
    $sql = "SELECT * FROM record10 WHERE 1=1";
    
    if (!empty($conditions)) {
        $sql .= " AND " . implode(" AND ", $conditions);
    }

    $sql .= " ORDER BY STR_TO_DATE(INSTALLATION_DATE, '%m/%d/%Y') DESC";

    $result = $conn->query($sql);

    if (!$result) {
        die("Error executing query: " . $conn->error);
    }

    if ($result->num_rows > 0) {
        echo '<div class="column-selector">';
        echo '<label>Select Columns to Print:</label>';
        $columns = ['ID','S/N', 'INSTALLATION_DATE', 'CLIENT_NAME', 'SALES_PERSON', 'VEHICLE_REG', 'MODEL', 'TRACKER_NUMBER', 'CONTACT', 'Bank', 'Bank_Branch', 'Tracker_Location', 'USERNAME', 'PASSWORD', 'LOAN_DURATION', 'C_NO', 'Expiry', 'TECHNICIAN', 'T_K', 'Tracksolid', 'IMEI', 'STATUS']; // Added IMEI
        foreach ($columns as $index => $column) {
            echo '<label><input type="checkbox" checked data-index="' . $index . '"> ' . htmlspecialchars($column) . '</label>';
        }
        echo '</div>';

        echo '<div class="table-container">';
        echo '<table>';
        echo '<thead><tr>';
        foreach ($columns as $index => $column) {
            echo '<th data-index="' . $index . '">' . htmlspecialchars($column) . '</th>';
        }
        echo '</tr></thead>';
        echo '<tbody>';
        $serialNumber = 1;
        $currentDate = new DateTime();

        function isRenewed($vehicleReg, $trackerNumber, $conn) {
            $query = "SELECT 1 FROM renewed_records WHERE VEHICLE_REG = '$vehicleReg' OR TRACKER_NUMBER = '$trackerNumber'";
            $result = $conn->query($query);
            return $result->num_rows > 0;
        }

        while ($row = $result->fetch_assoc()) {
            $expiryDate = DateTime::createFromFormat('m/d/Y', $row['expiray']);
            $isExpired = ($expiryDate && $currentDate > $expiryDate);
            $loanDuration = isset($row['LOAN_DURATION']) ? $row['LOAN_DURATION'] : '';
            $isZeroOrEmptyLoan = (empty($loanDuration) || $loanDuration === '0');
            $isRenewed = isRenewed($row['VEHICLE_REG'], $row['TRACKER_NUMBER'], $conn);

            // Determine status
            if ($isZeroOrEmptyLoan) {
                $status = 'Zero or Empty Loan';
                $rowClass = 'no-loan-duration';
            } elseif ($isExpired) {
                $status = 'Expired';
                $rowClass = 'expired';
            } else {
                $status = 'Active';
                $rowClass = 'active';
            }

            // Determine cell color for LOAN_DURATION
            $loanDurationColor = $isRenewed ? 'background-color: brown;' : '';

            echo "<tr class='$rowClass'>";
            echo "<td>" . $row["ID"] . "</td>";
            echo "<td>" . $serialNumber . "</td>";
            echo "<td>" . $row["INSTALLATION_DATE"] . "</td>";
            echo "<td>" . $row["CLIENT_NAME"] . "</td>";
            echo "<td>" . $row["SALES_PERSON"] . "</td>";
            echo "<td>" . $row["VEHICLE_REG"] . "</td>";
            echo "<td>" . $row["MODEL"] . "</td>";
            echo "<td>" . $row["TRACKER_NUMBER"] . "</td>";
            echo "<td>" . $row["CONTACT"] . "</td>";
            echo "<td>" . $row["Bank"] . "</td>";
            echo "<td>" . $row["Bank_Branch"] . "</td>"; // Added Bank_Branch
            echo "<td>" . $row["Tracker_Location"] . "</td>"; // Added Tracker_Location
            echo "<td>" . $row["USERNAME"] . "</td>";
            echo "<td>" . $row["PASSWORD"] . "</td>";
            echo "<td style='$loanDurationColor'>" . $row["LOAN_DURATION"] . "</td>";
            echo "<td>" . $row["C_NO"] . "</td>";
            echo "<td>" . $row["expiray"] . "</td>";
            echo "<td>" . $row["TECHNICIAN"] . "</td>";
            echo "<td>" . $row["T_K"] . "</td>";
            echo "<td>" . $row["Tracksolid"] . "</td>";
            echo "<td>" . $row["IMEI"] . "</td>"; // Added IMEI
            echo "<td>" . $status . "</td>";
            echo "</tr>";
            $serialNumber++;
        }

        echo '</tbody>';
        echo '</table>';
        echo '</div>';

        echo '<button class="print-button" onclick="handlePrint()">Print Report</button>';
        echo '<button class="export-button" onclick="exportToExcel()">Export to Excel</button>';
    } else {
        echo '<p style="text-align: center; color: white;">No records found.</p>';
    }

    $conn->close();
}

function sanitize($data, $conn) {
    return $conn->real_escape_string($data);
}

function formatDate($date) {
    return date('m/d/Y', strtotime($date));
}
?>
</body>
</html>