<?php
// Include the database connection
include 'conn.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Capture form input
    $installation_date = $_POST['installation_date'];
    $client_name = $_POST['client_name'];
    $contact = $_POST['contact'];
    $reg_no = $_POST['reg_no'];
    $model = $_POST['model'];
    $device_type = $_POST['device_type'];
    $tracker_no = $_POST['tracker_no'];
    $technician = $_POST['technician'];
    $sales_person = $_POST['sales_person'];
    $comments = $_POST['comments'] ?? ''; // Optional field

    // Normalize the date format (if needed)
    $dateTime = DateTime::createFromFormat('m/d/Y', $installation_date) ?: DateTime::createFromFormat('n/j/Y', $installation_date);
    if ($dateTime) {
        $normalized_date = $dateTime->format('Y-m-d');
    } else {
        echo "<p style='color:red;'>Invalid installation date format.</p>";
        $normalized_date = '';
    }

    // Insert data into the database
    if (!empty($normalized_date) && !empty($client_name)) {
        $sql = "INSERT INTO finemarkfuelrecord (DATE_OF_INSTALLATION, CLIENT_NAME, CONTACT, REG_NO, MODEL, DEVICE_TYPE, TRACKER_NO, TECHNICIAN, SALES_PERSON, COMMENTS)
                VALUES ('$normalized_date', '$client_name', '$contact', '$reg_no', '$model', '$device_type', '$tracker_no', '$technician', '$sales_person', '$comments')";
        
        if ($conn->query($sql) === TRUE) {
            echo "<p style='color:green;'>Record added successfully!</p>";
        } else {
            echo "<p style='color:red;'>Error: " . $conn->error . "</p>";
        }
    } else {
        echo "<p style='color:red;'>Please fill in all required fields.</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Record</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
    <style>
        /* Basic styles for the form */
        body {
            font-family: Arial, sans-serif;
            background-color: #e3f2fd; /* Light blue background */
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 500px; /* Reduced width for the form */
            margin: auto;
            background: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            color: #1976d2; /* Blue color */
        }
        .form-group {
            margin-bottom: 15px;
            position: relative;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="text"], input[type="date"] {
            width: 90%; /* Full width of the form */
           /* Limit the width */
            padding: 8px 10px; /* Reduced padding */
            padding-left: 40px; /* Add padding for icon space */
            border: 1px solid #1976d2; /* Blue border */
            border-radius: 4px;
            transition: border 0.3s; /* Transition for border color on focus */
        }
        input[type="text"]:focus, input[type="date"]:focus {
            border-color: #42a5f5; /* Lighter blue on focus */
            outline: none; /* Remove default outline */
        }
        input[type="submit"] {
            background: #1976d2; /* Blue background */
            color: white;
            border: none;
            padding: 10px;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
            font-size: 16px;
            margin-top: 10px;
            transition: background 0.3s; /* Transition for button background */
        }
        input[type="submit"]:hover {
            background: #1565c0; /* Darker blue on hover */
        }
        .icon {
            position: absolute;
            left: 10px;
            top: 50%;
            font-size: 20px;
            color: #1976d2; /* Match icon color with theme */
        }
        .button-container {
            text-align: center;
            margin-top: 20px;
        }
        .return-button {
            background: #28a745;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            text-decoration: none;
            transition: background 0.3s;
        }
        .return-button:hover {
            background: #218838; /* Darker green on hover */
        }
        @media (max-width: 600px) {
            body {
                padding: 10px;
            }
            .container {
                padding: 15px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Add New Record</h2>
    
    <form method="POST" action="">
        <div class="form-group">
            <i class="fas fa-calendar-alt icon"></i>
            <label for="installation_date">Date of Installation:</label>
            <input type="date" id="installation_date" name="installation_date" required>
        </div>
        <div class="form-group">
            <i class="fas fa-user icon"></i>
            <label for="client_name">Client Name:</label>
            <input type="text" id="client_name" name="client_name" placeholder="Enter client name" required>
        </div>
        <div class="form-group">
            <i class="fas fa-phone icon"></i>
            <label for="contact">Contact:</label>
            <input type="text" id="contact" name="contact" placeholder="Enter contact number" required>
        </div>
        <div class="form-group">
            <i class="fas fa-car icon"></i>
            <label for="reg_no">Registration Number:</label>
            <input type="text" id="reg_no" name="reg_no" placeholder="Enter registration number" required>
        </div>
        <div class="form-group">
            <i class="fas fa-cogs icon"></i>
            <label for="model">Model:</label>
            <input type="text" id="model" name="model" placeholder="Enter model" required>
        </div>
        <div class="form-group">
            <i class="fas fa-device icon"></i>
            <label for="device_type">Device Type:</label>
            <input type="text" id="device_type" name="device_type" placeholder="Enter device type" required>
        </div>
        <div class="form-group">
            <i class="fas fa-barcode icon"></i>
            <label for="tracker_no">Tracker Number:</label>
            <input type="text" id="tracker_no" name="tracker_no" placeholder="Enter tracker number" required>
        </div>
        <div class="form-group">
            <i class="fas fa-wrench icon"></i>
            <label for="technician">Technician:</label>
            <input type="text" id="technician" name="technician" placeholder="Enter technician name" required>
        </div>
        <div class="form-group">
            <i class="fas fa-user-tie icon"></i>
            <label for="sales_person">Sales Person:</label>
            <input type="text" id="sales_person" name="sales_person" placeholder="Enter sales person name" required>
        </div>
        <div class="form-group">
            <i class="fas fa-comment-dots icon"></i>
            <label for="comments">Comments:</label>
            <input type="text" id="comments" name="comments" placeholder="Enter any comments (optional)">
        </div>
        <input type="submit" value="Add Record">
    </form>
    
    <div class="button-container">
        <a href="dashboard.php" class="return-button">Return to Dashboard</a>
    </div>
</div>

</body>
</html>
