<?php
// Include the database connection
include 'conn.php';

$searchResults = [];

if (isset($_GET['search'])) {
    // Capture the search input, allowing empty values
    $installation_date = $_GET['installation_date'] ?? '';
    $client_name = $_GET['client_name'] ?? '';
    $contact = $_GET['contact'] ?? '';
    $reg_no = $_GET['reg_no'] ?? '';
    $model = $_GET['model'] ?? '';
    $device_type = $_GET['device_type'] ?? '';
    $tracker_no = $_GET['tracker_no'] ?? '';
    $technician = $_GET['technician'] ?? '';
    $sales_person = $_GET['sales_person'] ?? '';

    // Construct the SQL query dynamically
    $sql = "SELECT * FROM finemarkfuelrecord WHERE 1=1"; // Base query
    
    // Add conditions based on user input
    if (!empty($installation_date)) {
        $sql .= " AND DATE_OF_INSTALLATION LIKE '%$installation_date%'";
    }
    if (!empty($client_name)) {
        $sql .= " AND CLIENT_NAME LIKE '%$client_name%'";
    }
    if (!empty($contact)) {
        $sql .= " AND CONTACT LIKE '%$contact%'";
    }
    if (!empty($reg_no)) {
        $sql .= " AND REG_NO LIKE '%$reg_no%'";
    }
    if (!empty($model)) {
        $sql .= " AND MODEL LIKE '%$model%'";
    }
    if (!empty($device_type)) {
        $sql .= " AND DEVICE_TYPE LIKE '%$device_type%'";
    }
    if (!empty($tracker_no)) {
        $sql .= " AND TRACKER_NO LIKE '%$tracker_no%'";
    }
    if (!empty($technician)) {
        $sql .= " AND TECHNICIAN LIKE '%$technician%'";
    }
    if (!empty($sales_person)) {
        $sql .= " AND SALES_PERSON LIKE '%$sales_person%'";
    }

    // Execute the query
    $result = $conn->query($sql);
    
    // Fetch the results
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $searchResults[] = $row;
        }
    } else {
        echo "<p>No results found.</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mark Tracking</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
            color: #333;
        }
        .container {
            width: 90%;
          
            margin: 50px auto;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }
        .search-form {
            padding: 20px;
            border-radius: 8px;
            background-color: #e9ecef;
            box-shadow: 0 1px 5px rgba(0, 0, 0, 0.1);
            margin-bottom: 30px; /* Space between the form and the table */
            display: flex;
            flex-wrap: wrap; /* Allow items to wrap */
            gap: 15px; /* Space between items */
        }
        .main_form {
            display: flex;
            flex-wrap: wrap;
            gap: 15px; /* Space between items */
        }
        .form-group {
            min-width: 220px; /* Minimum width for better responsiveness */
        }
        label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
        }
        input {
            padding: 10px 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
            transition: border-color 0.3s;
        }
        input:focus {
            border-color: #007bff;
            outline: none;
        }
        .submit-btn {
            width: 100%;
            padding: 10px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }
        .submit-btn:hover {
            background-color: #0056b3;
        }
        .results-table {
            width: 100%;
            border-collapse: collapse;
            max-height: 90vh; /* Limit the height of the table */
            overflow-y: auto; /* Enable vertical scrolling */
            display: block; /* Allows scrolling */
        }
        .results-table thead {
            position: sticky; /* Make the header sticky */
            top: 0; /* Position it at the top */
            background-color: #007bff; /* Match the background with header color */
            z-index: 1; /* Ensure it is above the body rows */
        }
        .results-table th, .results-table td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        .results-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .scrollable-table-container {
            max-width: 100%;
            overflow-x: auto; /* Enable horizontal scrolling */
        }
        .table-scroll {
            display: block; /* Allows scrolling */
            max-height: 90vh; /* Set a max height for the table */
            overflow-y: auto; /* Enable vertical scrolling */
        }
        @media (max-width: 768px) {
            .form-group {
                flex: 1 1 100%; /* Stack form groups on smaller screens */
            }
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Fine Mark Tracking</h2>
    <h2>Fuel System</h2>
    
    <!-- Search Form -->
    <div class="search-form">
        <form method="GET" action="" style="width: 100%;">
            <div class="main_form"> 
                 <div class="form-group">
                    <label for="installation_date">Date of Installation:</label>
                    <input type="date" id="installation_date" name="installation_date" >
                </div>
                
                <div class="form-group">
                    <label for="client_name">Client Name:</label>
                    <input type="text" id="client_name" name="client_name" placeholder="Enter client name">
                </div>
                <div class="form-group">
                    <label for="contact">Contact:</label>
                    <input type="text" id="contact" name="contact" placeholder="Enter contact number">
                </div>
                <div class="form-group">
                    <label for="reg_no">Registration Number:</label>
                    <input type="text" id="reg_no" name="reg_no" placeholder="Enter registration number">
                </div>
                <div class="form-group">
                    <label for="model">Model:</label>
                    <input type="text" id="model" name="model" placeholder="Enter model">
                </div>
                <div class="form-group">
                    <label for="device_type">Device Type:</label>
                    <input type="text" id="device_type" name="device_type" placeholder="Enter device type">
                </div>
                <div class="form-group">
                    <label for="tracker_no">Tracker Number:</label>
                    <input type="text" id="tracker_no" name="tracker_no" placeholder="Enter tracker number">
                </div>
                <div class="form-group">
                    <label for="technician">Technician:</label>
                    <input type="text" id="technician" name="technician" placeholder="Enter technician name">
                </div>
                <div class="form-group">
                    <label for="sales_person">Sales Person:</label>
                    <input type="text" id="sales_person" name="sales_person" placeholder="Enter sales person name">
                </div>
                <div class="form-group">
                    <input type="submit" class="submit-btn" name="search" value="Search">
                </div>
            </div>
        </form>
    </div>

    <!-- Results Table -->
    <div class="table-scroll">
        <table class="results-table">
            <thead>
                <tr>
                    <th>Date of Installation</th>
                    <th>Client Name</th>
                    <th>Contact</th>
                    <th>Registration Number</th>
                    <th>Model</th>
                    <th>Device Type</th>
                    <th>Tracker Number</th>
                    <th>Technician</th>
                    <th>Sales Person</th>
                    <th>Comments</th>
                    <th>Logins</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($searchResults as $result): ?>
                <tr>
                    <td><?php echo htmlspecialchars($result['DATE_OF_INSTALLATION']); ?></td>
                    <td><?php echo htmlspecialchars($result['CLIENT_NAME']); ?></td>
                    <td><?php echo htmlspecialchars($result['CONTACT']); ?></td>
                    <td><?php echo htmlspecialchars($result['REG_NO']); ?></td>
                    <td><?php echo htmlspecialchars($result['MODEL']); ?></td>
                    <td><?php echo htmlspecialchars($result['DEVICE_TYPE']); ?></td>
                    <td><?php echo htmlspecialchars($result['TRACKER_NO']); ?></td>
                    <td><?php echo htmlspecialchars($result['TECHNICIAN']); ?></td>
                    <td><?php echo htmlspecialchars($result['SALES_PERSON']); ?></td>
                    <td><?php echo htmlspecialchars($result['COMMENTS']); ?></td>
                    <td><?php echo htmlspecialchars($result['LOGINS']); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

</body>
</html>
