<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fine Mark Stock System</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #e0f7fa;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 1000px;
            margin: 50px auto;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
            border: 1px solid #ddd;
        }
        h1 {
            color: #0277bd;
            text-align: center;
            font-size: 2em;
            margin-bottom: 30px;
        }
        .dashboard-links {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }
        .dashboard-link {
            display: flex;
            align-items: center;
            padding: 15px;
            text-align: center;
            background-color: #0288d1;
            color: #ffffff;
            text-decoration: none;
            border-radius: 4px;
            font-size: 1em;
            transition: background-color 0.3s, transform 0.3s;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            overflow: hidden; /* Ensures text and icons stay within the button */
        }
        .dashboard-link:hover {
            background-color: #0277bd;
            transform: scale(1.02);
        }
        .dashboard-link i {
            margin-right: 10px;
            font-size: 1.2em;
        }
        @media (max-width: 768px) {
            .dashboard-link {
                font-size: 0.9em;
            }
            .dashboard-link i {
                font-size: 1em;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Fine Mark Stock System</h1>
        <div class="dashboard-links">
            <a href="insert_gadget.php" class="dashboard-link">
                <i class="fas fa-plus"></i> Insert Gadget
            </a>
            <a href="insert_assigned_stock.php" class="dashboard-link">
                <i class="fas fa-eye"></i> Assign
            </a>
            <a href="manage_inventory.php" class="dashboard-link">
                <i class="fas fa-box"></i> Manage Inventory
            </a>
            <a href="sales_report.php" class="dashboard-link">
                <i class="fas fa-chart-line"></i> Sales Report
            </a>
            <a href="user_management.php" class="dashboard-link">
                <i class="fas fa-users"></i> User Management
            </a>
            <a href="settings.php" class="dashboard-link">
                <i class="fas fa-cogs"></i> Settings
            </a>
            <a href="orders.php" class="dashboard-link">
                <i class="fas fa-shopping-cart"></i> Orders
            </a>
            <a href="suppliers.php" class="dashboard-link">
                <i class="fas fa-truck"></i> Suppliers
            </a>
            <a href="purchase_history.php" class="dashboard-link">
                <i class="fas fa-history"></i> Purchase History
            </a>
            <a href="returns.php" class="dashboard-link">
                <i class="fas fa-undo"></i> Returns
            </a>
            <a href="notifications.php" class="dashboard-link">
                <i class="fas fa-bell"></i> Notifications
            </a>
            <a href="support.php" class="dashboard-link">
                <i class="fas fa-headset"></i> Support
            </a>
            <a href="reports.php" class="dashboard-link">
                <i class="fas fa-file-alt"></i> Reports
            </a>
            <a href="analytics.php" class="dashboard-link">
                <i class="fas fa-pie-chart"></i> Analytics
            </a>
            <a href="feedback.php" class="dashboard-link">
                <i class="fas fa-comment-dots"></i> Feedback
            </a>
        </div>
    </div>
</body>
</html>
