<?php
// Include the existing database connection
include 'conn.php'; 

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', 'error.log');

$message = ""; // Initialize message variable
$imeis = []; // Array to hold available IMEI numbers

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $gadget_imei = $_POST['gadget_imei'];
    $gadget_type = $_POST['gadget_type'];
    $technician = $_POST['technician'];

    // Prepare and bind
    $stmt = $conn->prepare("INSERT INTO assigned_stock (gadget_imei, gadget_type, technician) VALUES (?, ?, ?)");
    if ($stmt === false) {
        $message = "Prepare failed: " . htmlspecialchars($conn->error);
    } else {
        $stmt->bind_param("sss", $gadget_imei, $gadget_type, $technician);

        // Execute the statement
        if ($stmt->execute()) {
            $message = "Stock assigned successfully!";
        } else {
            $message = "Error: " . htmlspecialchars($stmt->error);
        }

        // Close the statement
        $stmt->close();
    }
}

// Get available IMEI numbers for a selected gadget type
if (isset($_GET['type'])) {
    $type = $_GET['type'];
    $stmt = $conn->prepare("SELECT gadget_imei FROM gadgets WHERE gadget_type = ?");
    $stmt->bind_param("s", $type);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $imeis[] = $row['gadget_imei'];
    }

    $stmt->close();
}

// Close the database connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Insert Assigned Stock</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #e0f7fa;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
            border: 1px solid #ddd;
        }
        h1 {
            color: #0277bd;
            text-align: center;
            font-size: 1.8em;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
            position: relative;
        }
        .form-group label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
            color: #333;
        }
        .form-group select,
        .form-group input[type="text"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 1em;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 12px;
            background-color: #0288d1;
            color: #ffffff;
            border: none;
            border-radius: 4px;
            font-size: 1em;
            cursor: pointer;
            text-align: center;
            transition: background-color 0.3s;
        }
        .btn:hover {
            background-color: #0277bd;
        }
        .message {
            color: #d32f2f;
            font-weight: bold;
            text-align: center;
            margin-bottom: 20px;
        }
        .message.success {
            color: #388e3c;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Assign Stock</h1>
        <?php if ($message): ?>
            <div class="message <?= strpos($message, 'Error') === false ? 'success' : '' ?>">
                <?= htmlspecialchars($message) ?>
            </div>
        <?php endif; ?>
        <form action="" method="post">
            <div class="form-group">
                <label for="gadget_type">Gadget Type</label>
                <select id="gadget_type" name="gadget_type" onchange="updateIMEI()">
                    <option value="">Select Gadget Type</option>
                    <!-- Add more gadget types as needed -->
                    <option value="Trackers">Trackers</option>
                    <option value="Fuel Sensors">Fuel Sensors</option>
                </select>
            </div>
            <div class="form-group">
                <label for="gadget_imei">Gadget IMEI</label>
                <select id="gadget_imei" name="gadget_imei">
                    <option value="">Select IMEI</option>
                    <?php foreach ($imeis as $imei): ?>
                        <option value="<?= htmlspecialchars($imei) ?>"><?= htmlspecialchars($imei) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="technician">Technician</label>
                <input type="text" id="technician" name="technician" required>
            </div>
            <button type="submit" class="btn">Assign Stock</button>
        </form>
    </div>

    <script>
        function updateIMEI() {
            const gadgetType = document.getElementById('gadget_type').value;
            const imeiSelect = document.getElementById('gadget_imei');

            if (gadgetType) {
                // Fetch IMEI numbers based on selected gadget type
                fetch(`insert_assigned_stock.php?type=${encodeURIComponent(gadgetType)}`)
                    .then(response => response.text())
                    .then(data => {
                        // Populate IMEI select box
                        imeiSelect.innerHTML = data;
                    });
            } else {
                imeiSelect.innerHTML = '<option value="">Select IMEI</option>';
            }
        }
    </script>
</body>
</html>
