<?php
// Include the existing database connection
include 'conn.php'; 

// Enable error reporting
error_reporting(E_ALL); // Report all types of errors
ini_set('display_errors', 1); // Display errors on the page
ini_set('log_errors', 1); // Log errors to a file
ini_set('error_log', 'error.log'); // Specify the error log file

$message = ""; // Initialize message variable

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $gadget_type = $_POST['gadget_type'];
    $gadget_imei = $_POST['gadget_imei'];
    $gadget_price = $_POST['gadget_price'];

    // Prepare and bind
    $stmt = $conn->prepare("INSERT INTO gadgets (gadget_type, gadget_imei, gadget_price) VALUES (?, ?, ?)");
    if ($stmt === false) {
        $message = "Prepare failed: " . htmlspecialchars($conn->error);
    } else {
        $stmt->bind_param("ssd", $gadget_type, $gadget_imei, $gadget_price);

        // Execute the statement
        if ($stmt->execute()) {
            $message = "New gadget inserted successfully!";
        } else {
            $message = "Error: " . htmlspecialchars($stmt->error);
        }

        // Close the statement
        $stmt->close();
    }
}

// Close the database connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Insert Gadget</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 400px;
            margin: 50px auto;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
            border: 1px solid #ddd;
        }
        h1 {
            color: #333;
            text-align: center;
            font-size: 1.5em;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
            position: relative;
        }
        .form-group label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
            color: #333;
        }
        .form-group select,
        .form-group input[type="text"],
        .form-group input[type="number"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 1em;
        }
        .form-group input[type="text"] {
            padding-left: 35px; /* Space for icon */
        }
        .form-group .icon {
            position: absolute;
            top: 50%;
            left: 10px;
            transform: translateY(-50%);
            color: #666;
            font-size: 1em;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 12px;
            background-color: #007bff;
            color: #ffffff;
            border: none;
            border-radius: 4px;
            font-size: 1em;
            cursor: pointer;
            text-align: center;
            transition: background-color 0.3s;
        }
        .btn:hover {
            background-color: #0056b3;
        }
        .message {
            color: #d32f2f;
            font-weight: bold;
            text-align: center;
            margin-bottom: 20px;
        }
        .message.success {
            color: #388e3c;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Insert Gadget</h1>
        <?php if ($message): ?>
            <div class="message <?= strpos($message, 'Error') === false ? 'success' : '' ?>">
                <?= htmlspecialchars($message) ?>
            </div>
        <?php endif; ?>
        <form action="" method="post">
            <div class="form-group">
                <label for="gadget_type">Gadget Type</label>
                <select id="gadget_type" name="gadget_type" required>
                    <option value="Trackers">Trackers</option>
                    <option value="Fuel Sensors">Fuel Sensors</option>
                </select>
            </div>
            <div class="form-group">
                <label for="gadget_imei">Gadget IMEI</label>
                <input type="text" id="gadget_imei" name="gadget_imei" required>
                <i class="fas fa-barcode icon"></i>
            </div>
            <div class="form-group">
                <label for="gadget_price">Gadget Price</label>
                <input type="number" id="gadget_price" name="gadget_price" step="0.01" required>
            </div>
            <button type="submit" class="btn">Insert Gadget</button>
        </form>
    </div>
</body>
</html>
