<?php
// Include the database connection file
include 'conn.php';

// Check if the form has been submitted
if (isset($_POST['submit'])) {
    // Check if a file was uploaded without errors
    if (isset($_FILES['csvFile']) && $_FILES['csvFile']['error'] == 0) {
        $fileTmpPath = $_FILES['csvFile']['tmp_name'];
        $fileName = $_FILES['csvFile']['name'];
        $fileSize = $_FILES['csvFile']['size'];
        $fileType = $_FILES['csvFile']['type'];
        $fileNameCmps = explode(".", $fileName);
        $fileExtension = strtolower(end($fileNameCmps));

        // Allow only CSV files
        if ($fileExtension == 'csv') {
            // Open the file for reading
            if (($file = fopen($fileTmpPath, 'r')) !== FALSE) {
                // Skip the header row
                fgetcsv($file);

                // Prepare the insert query
                $query = "INSERT INTO finemarkfuelrecord (DATE_OF_INSTALLATION, CLIENT_NAME, CONTACT, REG_NO, MODEL, DEVICE_TYPE, TRACKER_NO, TECHNICIAN, SALES_PERSON, COMMENTS, LOGINS) 
                          VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                $stmt = $conn->prepare($query);

                // Check if the statement prepared successfully
                if (!$stmt) {
                    die("Error preparing statement: " . $conn->error);
                }

                // Bind parameters for insertion
                $stmt->bind_param(
                    'sssssssssss',
                    $DATE_OF_INSTALLATION,
                    $CLIENT_NAME,
                    $CONTACT,
                    $REG_NO,
                    $MODEL,
                    $DEVICE_TYPE,
                    $TRACKER_NO,
                    $TECHNICIAN,
                    $SALES_PERSON,
                    $COMMENTS,
                    $LOGINS
                );

                // Initialize row count
                $rowCount = 0;

                // Insert data row by row
                while (($row = fgetcsv($file)) !== FALSE) {
                    // Map CSV columns to variables
                    $DATE_OF_INSTALLATION = $row[0];
                    $CLIENT_NAME = $row[1];
                    $CONTACT = $row[2];
                    $REG_NO = $row[3];
                    $MODEL = $row[4];
                    $DEVICE_TYPE = $row[5];
                    $TRACKER_NO = $row[6];
                    $TECHNICIAN = $row[7];
                    $SALES_PERSON = $row[8];
                    $COMMENTS = $row[9];
                    $LOGINS = $row[10];

                    // Execute the prepared statement
                    if (!$stmt->execute()) {
                        echo "Error inserting row: " . $stmt->error . "<br>";
                    } else {
                        $rowCount++;
                    }
                }

                // Close the file and the statement
                fclose($file);
                $stmt->close();
                $conn->close();

                echo "Successfully imported $rowCount rows.";
            } else {
                echo "Error opening the file.";
            }
        } else {
            echo "Please upload a valid CSV file.";
        }
    } else {
        echo "Error uploading the file. Please try again.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CSV File Upload</title>
</head>
<body>

<h2>Upload CSV File</h2>
<form action="" method="post" enctype="multipart/form-data">
    <label for="csvFile">Select CSV file to upload:</label>
    <input type="file" name="csvFile" id="csvFile" accept=".csv" required>
    <br><br>
    <input type="submit" name="submit" value="Upload CSV">
</form>

</body>
</html>
