<?php
// Include FPDF and FPDI manually
require 'fpdf.php'; // Adjust the path as needed
require 'fpdi/src/autoload.php'; // Adjust the path as needed

use setasign\Fpdi\Fpdi;
use setasign\Fpdi\PdfReader\StreamReader;

function generatePDF($fileBytes, $recipientName, $certificateNumber) {
    $pdf = new Fpdi();
    $pdf->AddPage();
    
    // Load the existing PDF file
    $pdf->setSourceFile(StreamReader::createFromString($fileBytes));
    $templateId = $pdf->importPage(1);
    $pdf->useTemplate($templateId);

    // Set font and color
    $pdf->SetFont('Helvetica', '', 30);
    $pdf->SetTextColor(0, 0, 0);

    // Add recipient name and certificate number to the PDF
    $pdf->SetXY(50, 100); // Adjust coordinates as needed
    $pdf->Cell(0, 10, 'Recipient: ' . $recipientName);
    
    $pdf->SetXY(50, 130); // Adjust coordinates as needed
    $pdf->Cell(0, 10, 'Certificate Number: ' . $certificateNumber);

    // Output the PDF
    return $pdf->Output('S');
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $recipientName = $_POST['recipient-name'] ?? '';
    $certificateNumber = $_POST['certificate-number'] ?? '';

    if (isset($_FILES['file-upload']) && $_FILES['file-upload']['error'] == UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['file-upload']['tmp_name'];
        $fileBytes = file_get_contents($fileTmpPath);

        // Generate the PDF
        $pdfBytes = generatePDF($fileBytes, $recipientName, $certificateNumber);

        // Serve the PDF for download
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment; filename="Certificate_' . htmlspecialchars($certificateNumber) . '.pdf"');
        echo $pdfBytes;
        exit;
    } else {
        echo 'Please upload a valid PDF template.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Certificate Generator</title>
</head>
<body>
    <h1>Certificate Generator</h1>
    <form id="certificate-form" method="post" enctype="multipart/form-data">
        <label for="file-upload">Upload PDF Template:</label>
        <input type="file" id="file-upload" name="file-upload" accept="application/pdf" required><br><br>

        <label for="recipient-name">Recipient Name:</label>
        <input type="text" id="recipient-name" name="recipient-name" required><br><br>
        
        <label for="certificate-number">Certificate Number:</label>
        <input type="text" id="certificate-number" name="certificate-number" required><br><br>
        
        <button type="submit">Generate Certificate</button>
    </form>
</body>
</html>
