<?php
// Include the database connection file
include('conn.php');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve user input
    $vehicle_reg = trim($_POST['vehicle_reg']);
    $client_name = trim($_POST['client_name']);
    $region_of_check_up = trim($_POST['region_of_check_up']);

    // Prepare and execute SQL query
    $stmt = $conn->prepare("INSERT INTO checkups (Vehicle_reg, Client_name, Region_Of_Check_Up) 
                            VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $vehicle_reg, $client_name, $region_of_check_up);
    
    if ($stmt->execute()) {
        $success_message = 'Check-up record added successfully!';
    } else {
        $error_message = 'Error: ' . $stmt->error;
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Insert Check-up Record</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f2f2f2;
            margin: 0;
            padding: 0;
        }
        .container {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            padding: 10px;
        }
        .form-container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 500px;
        }
        .form-container h2 {
            margin: 0 0 20px;
            font-size: 24px;
            text-align: center;
        }
        .form-container label {
            display: block;
            margin-bottom: 8px;
        }
        .form-container input,
        .form-container select {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        .form-container input[type="submit"] {
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
        }
        .form-container input[type="submit"]:hover {
            background-color: #45a049;
        }
        .message {
            text-align: center;
            margin-bottom: 15px;
        }
        .message.success {
            color: green;
        }
        .message.error {
            color: red;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="form-container">
            <h2>Add Check-up Record</h2>
            
            <?php if (isset($success_message)): ?>
                <div class="message success"><?php echo htmlspecialchars($success_message); ?></div>
            <?php endif; ?>
            
            <?php if (isset($error_message)): ?>
                <div class="message error"><?php echo htmlspecialchars($error_message); ?></div>
            <?php endif; ?>
            
            <form action="insert_checkup.php" method="post">
                <label for="vehicle_reg">Vehicle Registration:</label>
                <input type="text" id="vehicle_reg" name="vehicle_reg" required>

                <label for="client_name">Client Name:</label>
                <input type="text" id="client_name" name="client_name" required>

                <label for="region_of_check_up">Region of Check-up:</label>
                <input type="text" id="region_of_check_up" name="region_of_check_up" required>

                <input type="submit" value="Submit">
            </form>
        </div>
    </div>
</body>
</html>
