<?php


// Include the session check
include 'session_check.php'; 


error_reporting(E_ALL); // Report all types of errors
ini_set('display_errors', 1); // Display errors on the screen

include 'conn.php'; // Include the database connection



// Initialize variables
$success_message = $error_message = '';

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve form data
    $vehicle_reg = $_POST['vehicle_reg'];
    $payment_date = $_POST['payment_date'];
    $client_name = $_POST['client_name'];
    $paid_via = $_POST['paid_via'];

    // Prepare and execute statement to check if vehicle_reg exists and get expiray date from record10 table
    if ($check_stmt = $conn->prepare("SELECT expiray FROM record10 WHERE vehicle_reg = ?")) {
        $check_stmt->bind_param("s", $vehicle_reg);
        $check_stmt->execute();
        $check_stmt->store_result(); // Store the result to free up resources

        if ($check_stmt->num_rows > 0) {
            $check_stmt->bind_result($expiray);
            $check_stmt->fetch();
            $check_stmt->close(); // Close the statement

            // Get current date
            $current_date = new DateTime();
            
            // Check if expiray date is valid
            $expiray_date = DateTime::createFromFormat('m/d/Y', $expiray);
            if ($expiray_date && $current_date <= $expiray_date) {
                // Prepare and execute statement to insert payment record
                if ($stmt = $conn->prepare("INSERT INTO received_payment (vehicle_reg, payment_date, client_name, paid_via) VALUES (?, ?, ?, ?)")) {
                    $stmt->bind_param("ssss", $vehicle_reg, $payment_date, $client_name, $paid_via);

                    if ($stmt->execute()) {
                        $success_message = "Payment record added successfully!";
                        // Redirect to the same page to prevent form resubmission
                        header("Location: insert_payment.php");
                        exit();
                    } else {
                        $error_message = "Error: Unable to add payment record. Please try again later.";
                    }

                    $stmt->close();
                } else {
                    $error_message = "Error: Unable to prepare statement for insertion.";
                }
            } else {
                // Expiray date has expired
                $error_message = "Error: The expiray date for vehicle registration '$vehicle_reg' has expired";
            }
        } else {
            // Vehicle registration does not exist
            $error_message = "Error: Vehicle Registration '$vehicle_reg' does not exist in the record10 table.";
        }
    } else {
        $error_message = "Error: Unable to prepare statement for checking vehicle registration.";
    }

    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mark Accounts</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            background-color: #007bff; /* Blue background */
            color: white;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }
        .form-group label {
            color: #333;
        }
        .btn-primary {
            background-color: #0056b3; /* Darker blue */
            border: none;
        }
        .btn-primary:hover {
            background-color: #004494; /* Even darker blue */
        }
        .alert {
            margin-bottom: 20px;
        }
        .icon {
            font-size: 3rem;
            color: #007bff;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <i class="fas fa-dollar-sign icon"></i>
        <h2 class="text-center">Insert Payment Record</h2>
        
        <?php if (!empty($success_message)): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success_message); ?></div>
        <?php endif; ?>

        <?php if (!empty($error_message)): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error_message); ?></div>
        <?php endif; ?>

        <form method="post" action="insert_payment.php">
            <div class="form-group">
                <label for="vehicle_reg"><i class="fas fa-car"></i> Vehicle Registration</label>
                <input type="text" class="form-control" id="vehicle_reg" name="vehicle_reg" required>
            </div>
            <div class="form-group">
                <label for="payment_date"><i class="fas fa-calendar-day"></i> Payment Date</label>
                <input type="date" class="form-control" id="payment_date" name="payment_date" required>
            </div>
            <div class="form-group">
                <label for="client_name"><i class="fas fa-user"></i> Client Name</label>
                <input type="text" class="form-control" id="client_name" name="client_name" required>
            </div>
            <div class="form-group">
                <label for="paid_via"><i class="fas fa-credit-card"></i> Paid Via</label>
                <input type="text" class="form-control" id="paid_via" name="paid_via" required>
            </div>
            <button type="submit" class="btn btn-primary"><i class="fas fa-check"></i> Submit</button>
        </form>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
