<?php
// Include the database connection
include('conn.php');

// Get the current date in MM/DD/YYYY format
$today = date('m/d/Y');

// Function to get the start date of the current week (7 days back from today)
function getWeekRange() {
    $endDate = date('m/d/Y');
    $startDate = date('m/d/Y', strtotime('-6 days'));  // 6 days before today to include today
    return [$startDate, $endDate];
}

// Function to get start and end dates of the current month
function getMonthRange() {
    $startDate = date('m/01/Y');
    $endDate = date('m/t/Y');
    return [$startDate, $endDate];
}

// Determine the filter to apply
$filter = isset($_POST['filter']) ? $_POST['filter'] : 'today';
$filterCondition = '';

switch ($filter) {
    case 'week':
        list($startDate, $endDate) = getWeekRange();
        $filterCondition = "INSTALLATION_DATE BETWEEN '$startDate' AND '$endDate'";
        $filterTitle = "This Week";
        break;
    case 'month':
        list($startDate, $endDate) = getMonthRange();
        $filterCondition = "INSTALLATION_DATE BETWEEN '$startDate' AND '$endDate'";
        $filterTitle = "This Month";
        break;
    case 'today':
    default:
        $filterCondition = "INSTALLATION_DATE = '$today'";
        $filterTitle = "Today";
        break;
}

// Query to get records based on the filter
$query = "SELECT * FROM record10 WHERE $filterCondition";
$result = $conn->query($query);
$recordCount = $result->num_rows;

// Query to get the number of units handled by each technician
$technicianQuery = "SELECT TECHNICIAN, COUNT(*) AS total FROM record10 WHERE $filterCondition GROUP BY TECHNICIAN ORDER BY total DESC";
$technicianResult = $conn->query($technicianQuery);

// Query to get the number of units handled by each salesperson
$salesPersonQuery = "SELECT SALES_PERSON, COUNT(*) AS total FROM record10 WHERE $filterCondition GROUP BY SALES_PERSON ORDER BY total DESC";
$salesPersonResult = $conn->query($salesPersonQuery);

// Query to get the number of units handled by each bank
$bankQuery = "SELECT Bank, COUNT(*) AS total FROM record10 WHERE $filterCondition GROUP BY Bank ORDER BY total DESC";
$bankResult = $conn->query($bankQuery);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation Records</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f0f8ff;
        }
        h2 {
            color: #1e90ff;
            text-align: center;
            margin-top: 20px;
            font-size: 24px;
        }
        form {
            text-align: center;
            margin: 20px auto;
        }
        select {
            padding: 10px;
            font-size: 16px;
            border: 2px solid #1e90ff;
            border-radius: 4px;
            background-color: #e6f7ff;
        }
        input[type="submit"] {
            padding: 10px 20px;
            font-size: 16px;
            background-color: #1e90ff;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        input[type="submit"]:hover {
            background-color: #4682b4;
        }
        .record-count {
            text-align: center;
            margin: 20px;
            font-size: 18px;
            color: #333;
        }
        .table-container {
            width: 100vw;
            overflow-x: auto; /* Enables horizontal scrolling */
            -webkit-overflow-scrolling: touch; /* Smooth scrolling on iOS */
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.2);
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 12px;
            text-align: left;
        }
        th {
            background-color: #87ceeb;
            color: #fff;
        }
        tr:nth-child(even) {
            background-color: #f0f8ff;
        }
        tr:hover {
            background-color: #e6f7ff;
        }
        @media (max-width: 768px) {
            table, th, td {
                font-size: 14px;
            }
        }
        .summary-report {
            margin: 20px;
        }
        .summary-report h3 {
            color: #1e90ff;
            font-size: 20px;
        }
        .summary-report h4 {
            color: #4682b4;
            font-size: 18px;
        }
        .summary-report table {
            width: 100%;
            border-collapse: collapse;
        }
        .summary-report th, .summary-report td {
            padding: 10px;
            border: 1px solid #ddd;
        }
        .summary-report th {
            background-color: #87ceeb;
            color: #fff;
        }
        .print-button {
            display: block;
            width: 200px;
            margin: 20px auto;
            padding: 10px;
            font-size: 16px;
            color: white;
            background-color: #32cd32;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        .print-button:hover {
            background-color: #228b22;
        }
    </style>
    <script>
        function printReport() {
            window.print();
        }
    </script>
</head>
<body>
    <h2>Installations for <?php echo $filterTitle; ?></h2>

    <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
        <label for="filter">Filter by:</label>
        <select id="filter" name="filter">
            <option value="today" <?php echo ($filter == 'today') ? 'selected' : ''; ?>>Today</option>
            <option value="week" <?php echo ($filter == 'week') ? 'selected' : ''; ?>>This Week</option>
            <option value="month" <?php echo ($filter == 'month') ? 'selected' : ''; ?>>This Month</option>
        </select>
        <input type="submit" value="Apply Filter">
    </form>

    <div class="record-count">
        <strong>Total Records: <?php echo $recordCount; ?></strong>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Installation Date</th>
                    <th>Client Name</th>
                    <th>Sales Person</th>
                    <th>Vehicle Registration</th>
                    <th>Model</th>
                    <th>Tracker Number</th>
                    <th>Contact</th>
                    <th>Bank</th>
                    <th>Technician</th>
                    <th>Loan Duration</th>
                    <th>Expiry</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($recordCount > 0) {
                    $counter = 1;  // Initialize counter
                    // Output data of each row
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . $counter++ . "</td>";  // Display sequential count
                        echo "<td>" . htmlspecialchars($row["INSTALLATION_DATE"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["CLIENT_NAME"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["SALES_PERSON"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["VEHICLE_REG"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["MODEL"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["TRACKER_NUMBER"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["CONTACT"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["Bank"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["TECHNICIAN"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["LOAN_DURATION"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["expiray"]) . "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='12'>No records found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <!-- Summary Report -->
    <div class="summary-report">
        <h3>Summary Report</h3>

        <button class="print-button" onclick="printReport()">Print Summary Report</button>

        <h4>Technician Units</h4>
        <table>
            <thead>
                <tr>
                    <th>Technician</th>
                    <th>Units</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($technicianResult->num_rows > 0) {
                    while ($row = $technicianResult->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($row["TECHNICIAN"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["total"]) . "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='2'>No data available</td></tr>";
                }
                ?>
            </tbody>
        </table>

        <h4>Salesperson Units</h4>
        <table>
            <thead>
                <tr>
                    <th>Salesperson</th>
                    <th>Units</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($salesPersonResult->num_rows > 0) {
                    while ($row = $salesPersonResult->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($row["SALES_PERSON"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["total"]) . "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='2'>No data available</td></tr>";
                }
                ?>
            </tbody>
        </table>

        <h4>Bank Units</h4>
        <table>
            <thead>
                <tr>
                    <th>Bank</th>
                    <th>Units</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($bankResult->num_rows > 0) {
                    while ($row = $bankResult->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($row["Bank"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["total"]) . "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='2'>No data available</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <?php
    // Close connection
    $conn->close();
    ?>
</body>
</html>
