<?php
// Include the database connection file
include('conn.php');

// Function to handle database operations
function handleRequest($conn) {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'fetch_details':
                // Fetch details for the vehicle registration
                $vehicle_reg = $_POST['vehicle_reg'];
                $stmt = $conn->prepare("SELECT * FROM record10 WHERE VEHICLE_REG = ?");
                $stmt->bind_param("s", $vehicle_reg);
                $stmt->execute();
                $result = $stmt->get_result();
                $details = $result->fetch_assoc();
                $stmt->close();
                
                if ($details) {
                    // Convert expiray date from mm/dd/yyyy to yyyy-mm-dd
                    $expiray_date = DateTime::createFromFormat('m/d/Y', $details['expiray']);
                    $formatted_expiray = $expiray_date ? $expiray_date->format('Y-m-d') : '0000-00-00';
                    
                    // Insert details into Checkups table
                    $stmt = $conn->prepare("INSERT INTO Checkups (vehicle_reg, client_name, contact, expiray) VALUES (?, ?, ?, ?)");
                    $stmt->bind_param("ssss", $details['VEHICLE_REG'], $details['CLIENT_NAME'], $details['CONTACT'], $formatted_expiray);
                    $stmt->execute();
                    $stmt->close();
                    return ['success' => true, 'message' => 'Record inserted successfully.'];
                } else {
                    return ['success' => false, 'message' => 'Vehicle registration not found.'];
                }
                
            case 'insert':
                insertRecord($conn);
                break;
            case 'update':
                updateRecord($conn);
                break;
            case 'delete':
                deleteRecord($conn);
                break;
        }
    }
}

function insertRecord($conn) {
    $stmt = $conn->prepare("INSERT INTO Checkups (vehicle_reg, client_name, contact, expiray) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $_POST['vehicle_reg'], $_POST['client_name'], $_POST['contact'], $_POST['expiray']);
    $stmt->execute();
    $stmt->close();
}

function updateRecord($conn) {
    $stmt = $conn->prepare("UPDATE Checkups SET expiray = ? WHERE vehicle_reg = ? AND client_name = ? AND contact = ?");
    $stmt->bind_param("ssss", $_POST['expiray'], $_POST['vehicle_reg'], $_POST['client_name'], $_POST['contact']);
    $stmt->execute();
    $stmt->close();
}

function deleteRecord($conn) {
    $stmt = $conn->prepare("DELETE FROM Checkups WHERE vehicle_reg = ? AND client_name = ? AND contact = ?");
    $stmt->bind_param("sss", $_POST['vehicle_reg'], $_POST['client_name'], $_POST['contact']);
    $stmt->execute();
    $stmt->close();
}

// Handle the request
$response = handleRequest($conn);

// Fetch all records for display
$result = $conn->query("SELECT * FROM Checkups");
$checkups = $result->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Checkups</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
        .form-container {
            max-width: 600px;
            margin: 20px auto;
            padding: 20px;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .form-container h2 {
            margin-top: 0;
            color: #333;
        }
        .form-container label {
            display: block;
            margin: 10px 0 5px;
            color: #555;
        }
        .form-container input[type="text"],
        .form-container input[type="date"] {
            width: calc(100% - 22px);
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            margin-bottom: 10px;
        }
        .form-container input[type="submit"] {
            background-color: #3498db;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        .form-container input[type="submit"]:hover {
            background-color: #2980b9;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 12px;
            text-align: left;
        }
        th {
            background-color: #3498db;
            color: white;
        }
        td {
            background-color: #fff;
        }
        .form-container i {
            margin-right: 8px;
        }
        .message {
            padding: 10px;
            color: #fff;
            border-radius: 4px;
            margin-bottom: 20px;
        }
        .message.success {
            background-color: #2ecc71;
        }
        .message.error {
            background-color: #e74c3c;
        }
    </style>
</head>
<body>
    <h1>Manage Checkups</h1>

    <!-- Display Message -->
    <?php if (isset($response)): ?>
        <div class="message <?php echo $response['success'] ? 'success' : 'error'; ?>">
            <?php echo htmlspecialchars($response['message']); ?>
        </div>
    <?php endif; ?>

    <!-- Lookup Form -->
    <div class="form-container">
        <h2><i class="fas fa-search"></i> Lookup Vehicle Details</h2>
        <form method="POST" action="manage_checkups.php">
            <input type="hidden" name="action" value="fetch_details">
            <label for="vehicle_reg_lookup">Vehicle Reg:</label>
            <input type="text" id="vehicle_reg_lookup" name="vehicle_reg" required>
            <input type="submit" value="Fetch Details">
        </form>
    </div>

    <!-- Insert Form -->
    <div class="form-container">
        <h2><i class="fas fa-plus"></i> Insert Record</h2>
        <form method="POST" action="manage_checkups.php">
            <input type="hidden" name="action" value="insert">
            <label for="vehicle_reg">Vehicle Reg:</label>
            <input type="text" id="vehicle_reg" name="vehicle_reg" required><br>
            <label for="client_name">Client Name:</label>
            <input type="text" id="client_name" name="client_name" required><br>
            <label for="contact">Contact:</label>
            <input type="text" id="contact" name="contact" required><br>
            <label for="expiray">Expiray Date:</label>
            <input type="date" id="expiray" name="expiray" required><br>
            <input type="submit" value="Insert">
        </form>
    </div>

    <!-- Update Form -->
    <div class="form-container">
        <h2><i class="fas fa-edit"></i> Update Record</h2>
        <form method="POST" action="manage_checkups.php">
            <input type="hidden" name="action" value="update">
            <label for="vehicle_reg_update">Vehicle Reg:</label>
            <input type="text" id="vehicle_reg_update" name="vehicle_reg" required><br>
            <label for="client_name_update">Client Name:</label>
            <input type="text" id="client_name_update" name="client_name" required><br>
            <label for="contact_update">Contact:</label>
            <input type="text" id="contact_update" name="contact" required><br>
            <label for="expiray_date_update">Expiray Date:</label>
            <input type="date" id="expiray_date_update" name="expiray_date" required><br>
            <input type="submit" value="Update">
        </form>
    </div>

    <!-- Delete Form -->
    <div class="form-container">
        <h2><i class="fas fa-trash"></i> Delete Record</h2>
        <form method="POST" action="manage_checkups.php">
            <input type="hidden" name="action" value="delete">
            <label for="vehicle_reg_delete">Vehicle Reg:</label>
            <input type="text" id="vehicle_reg_delete" name="vehicle_reg" required><br>
            <label for="client_name_delete">Client Name:</label>
            <input type="text" id="client_name_delete" name="client_name" required><br>
            <label for="contact_delete">Contact:</label>
            <input type="text" id="contact_delete" name="contact" required><br>
            <input type="submit" value="Delete">
        </form>
    </div>

    <!-- Display Records -->
    <div class="form-container">
        <h2><i class="fas fa-table"></i> Current Records</h2>
        <table>
            <thead>
                <tr>
                    <th>Vehicle Reg</th>
                    <th>Client Name</th>
                    <th>Contact</th>
                    <th>Expiray</th>
                    <th>Date of Checkup</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($checkups as $checkup): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($checkup['vehicle_reg']); ?></td>
                        <td><?php echo htmlspecialchars($checkup['client_name']); ?></td>
                        <td><?php echo htmlspecialchars($checkup['contact']); ?></td>
                        <td><?php echo htmlspecialchars($checkup['expiray']); ?></td>
                        <td><?php echo htmlspecialchars($checkup['date_of_checkup']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
