<?php
// Include the session check
include 'session_check.php'; 

// Display errors for debugging purposes (should be disabled in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include the connection page
include 'conn.php';

// Initialize variables
$success_message = $error_message = '';
$phone_number = $full_name = '';

// Handle adding, editing, and deleting technicians
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['add_technician'])) {
        // Add new technician
        $phone_number = trim($_POST['phone_number']);
        $full_name = trim($_POST['full_name']);

        // Check if phone number already exists
        $check_stmt = $conn->prepare("SELECT 1 FROM technician WHERE phone_number = ?");
        $check_stmt->bind_param("s", $phone_number);
        $check_stmt->execute();
        $check_stmt->store_result();

        if ($check_stmt->num_rows > 0) {
            $error_message = "Error: Technician with Phone Number '$phone_number' already exists.";
        } else {
            // Proceed with insertion
            $insert_stmt = $conn->prepare("INSERT INTO technician (phone_number, full_name) VALUES (?, ?)");
            $insert_stmt->bind_param("ss", $phone_number, $full_name);

            if ($insert_stmt->execute()) {
                $success_message = "New technician added successfully";
            } else {
                $error_message = "Error: Unable to add technician. Please try again later.";
            }

            $insert_stmt->close();
        }

        $check_stmt->close();
    } elseif (isset($_POST['edit_technician'])) {
        // Edit existing technician
        $phone_number = trim($_POST['phone_number']);
        $new_full_name = trim($_POST['full_name']);

        // Update technician table with new full name
        $update_stmt = $conn->prepare("UPDATE technician SET full_name = ? WHERE phone_number = ?");
        $update_stmt->bind_param("ss", $new_full_name, $phone_number);

        if ($update_stmt->execute()) {
            $success_message = "Technician record updated successfully";
        } else {
            $error_message = "Error updating technician record: " . $conn->error;
        }

        $update_stmt->close();
    }
}

// Handle deleting technician
if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET['delete'])) {
    $phone_number = trim($_GET['phone_number']);

    // Delete technician from technician table
    $delete_stmt = $conn->prepare("DELETE FROM technician WHERE phone_number = ?");
    $delete_stmt->bind_param("s", $phone_number);

    if ($delete_stmt->execute()) {
        $success_message = "Technician record deleted successfully";
    } else {
        $error_message = "Error deleting technician record: " . $conn->error;
    }

    $delete_stmt->close();
}

// Fetch all technicians for display
$select_stmt = $conn->prepare("SELECT phone_number, full_name FROM technician");
$select_stmt->execute();
$select_stmt->bind_result($phone_number, $full_name);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Technicians</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2 class="text-center">Manage Technicians</h2>
        <?php
        if (!empty($success_message)) {
            echo '<div class="alert alert-success">' . htmlspecialchars($success_message) . '</div>';
        }
        if (!empty($error_message)) {
            echo '<div class="alert alert-danger">' . htmlspecialchars($error_message) . '</div>';
        }
        ?>
        <!-- Add and Edit Technician Form -->
        <div class="card mb-3">
            <div class="card-header">
                <?php if (isset($_GET['phone_number'])): ?>
                    Edit Technician
                <?php else: ?>
                    Add New Technician
                <?php endif; ?>
            </div>
            <div class="card-body">
                <form action="manage_technicians.php" method="post">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="phone_number">Phone Number</label>
                            <input type="text" class="form-control" id="phone_number" name="phone_number" value="<?php echo isset($_GET['phone_number']) ? htmlspecialchars($_GET['phone_number']) : ''; ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="full_name">Full Name</label>
                            <input type="text" class="form-control" id="full_name" name="full_name" value="<?php echo isset($_GET['phone_number']) ? htmlspecialchars($full_name) : ''; ?>" required>
                        </div>
                    </div>
                    <?php if (isset($_GET['phone_number'])): ?>
                        <button type="submit" class="btn btn-primary" name="edit_technician">Update Technician</button>
                    <?php else: ?>
                        <button type="submit" class="btn btn-primary" name="add_technician">Add Technician</button>
                    <?php endif; ?>
                     <a href="dashboard.php" style="display: inline-block; padding: 8px 15px; font-size: 14px; text-decoration: none; color: #fff; background-color: brown; border-radius: 5px; text-align: center; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); transition: background-color 0.3s ease;">Return To Dashboard</a>
                     <p>Mind editing/Deleting a technician as it will affect records done by that technician<p>
                </form>
            </div>
        </div>

        <!-- List of Technicians -->
        <div class="card">
            <div class="card-header">
                List of Technicians
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Phone Number</th>
                            <th>Full Name</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($select_stmt->fetch()) { ?>
                            <tr>
                                <td><?php echo htmlspecialchars($phone_number); ?></td>
                                <td><?php echo htmlspecialchars($full_name); ?></td>
                                <td>
                                    <a href="manage_technicians.php?phone_number=<?php echo urlencode($phone_number); ?>" class="btn btn-sm btn-primary">Edit</a>
                                    <a href="manage_technicians.php?delete=true&phone_number=<?php echo urlencode($phone_number); ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this technician?')">Delete</a>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
