<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include the database connection
include 'conn.php';

$vehicle_details = null;
$error_message = null;

// Check if the form has been submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['vehicle_reg_submit'])) {
        // Step 1: User submits the vehicle registration number
        $vehicle_reg = $_POST['vehicle_reg'];

        // Fetch details from the record10 table based on the vehicle registration number
        $stmt = $conn->prepare("SELECT 
            INSTALLATION_DATE, CLIENT_NAME, VEHICLE_REG, MODEL, TRACKER_NUMBER, 
            CONTACT, TECHNICIAN, LOAN_DURATION, expiray 
            FROM record10 WHERE VEHICLE_REG = ?");
        $stmt->bind_param("s", $vehicle_reg);
        $stmt->execute();
        $result = $stmt->get_result();
        $vehicle_details = $result->fetch_assoc();

        if (!$vehicle_details) {
            $error_message = "No details found for the given vehicle registration number.";
        }

        $stmt->close();
    } elseif (isset($_POST['save_payment'])) {
        // Step 2: User submits the payment details
        $VEHICLE_REG = $_POST['vehicle_reg'];
        $TECHNICIAN = $_POST['TECHNICIAN'];
        $CLIENT_NAME = $_POST['CLIENT_NAME'];
        $MODEL = $_POST['MODEL'];
        $TRACKER_NUMBER = $_POST['TRACKER_NUMBER'];
        $CONTACT = $_POST['CONTACT'];
        $LOAN_DURATION = $_POST['LOAN_DURATION'];
        $expiray = $_POST['expiray'];
        $amount_paid = $_POST['amount_paid'];
        $INSTALLATION_DATE = $_POST['INSTALLATION_DATE'] ?: NULL;

        // Prepare the SQL statement
        $stmt = $conn->prepare("INSERT INTO `paid_installations` (
            `INSTALLATION_DATE`, `CLIENT_NAME`, `VEHICLE_REG`, `MODEL`, 
            `TRACKER_NUMBER`, `CONTACT`, `TECHNICIAN`, `LOAN_DURATION`, 
            `expiray`, `amount_paid`, `date_paid`
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP)");

        // Bind the parameters
        $stmt->bind_param(
            "ssssssssss",
            $INSTALLATION_DATE,
            $CLIENT_NAME,
            $VEHICLE_REG,
            $MODEL,
            $TRACKER_NUMBER,
            $CONTACT,
            $TECHNICIAN,
            $LOAN_DURATION,
            $expiray,
            $amount_paid
        );

        // Execute the statement and check for errors
        if ($stmt->execute()) {
            // Redirect to avoid resubmission
            header("Location: payment.php?success=1");
            exit();
        } else {
            $error_message = "Error: " . $stmt->error;
        }

        $stmt->close();
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Record Payment</title>
    <link rel="stylesheet" href="styles.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<style>
    /* Reset some default styles */
body, h1, h2, p, input, form, a {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

/* Basic styling for the page */
body {
    font-family: Arial, sans-serif;
    background-color: #f4f4f9;
    color: #333;
    line-height: 1.6;
    padding: 20px;
}

h1 {
    text-align: center;
    margin-bottom: 20px;
    color: #0056b3;
}

h2 {
    color: #007bff;
    margin-bottom: 15px;
}

/* Form styling */
form {
    max-width: 800px;
    margin: 0 auto;
    background: #fff;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 0 10px rgba(0,0,0,0.1);
}

label {
    display: block;
    font-weight: bold;
    margin-bottom: 5px;
}

input[type="text"], input[type="submit"] {
    width: calc(100% - 22px);
    padding: 10px;
    margin-bottom: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

input[type="submit"] {
    background: #007bff;
    color: #fff;
    border: none;
    cursor: pointer;
    font-size: 16px;
}

input[type="submit"]:hover {
    background: #0056b3;
}

.error {
    color: red;
    text-align: center;
    margin-bottom: 20px;
}

.success {
    color: green;
    text-align: center;
    margin-bottom: 20px;
}

.btn-return {
    display: inline-block;
    padding: 10px 20px;
    margin-top: 20px;
    background: #007bff;
    color: #fff;
    text-decoration: none;
    border-radius: 4px;
    font-size: 16px;
}

.btn-return:hover {
    background: #0056b3;
}

.btn-return i {
    margin-right: 8px;
}

/* Media queries for responsive design */
@media (max-width: 768px) {
    input[type="text"], input[type="submit"] {
        width: calc(100% - 18px);
    }

    form {
        padding: 15px;
    }
}

</style>
<body>
    <h1>Record Payment</h1>
    
    <!-- Display error message if any -->
    <?php if ($error_message): ?>
        <p class="error"><?= htmlspecialchars($error_message); ?></p>
    <?php elseif (isset($_GET['success']) && $_GET['success'] == 1): ?>
        <p class="success">Payment details successfully recorded.</p>
    <?php endif; ?>
    
    <!-- Step 1: Form to submit vehicle registration number -->
    <form action="payment.php" method="POST">
        <label for="vehicle_reg">Vehicle Registration Number:</label>
        <input type="text" id="vehicle_reg" name="vehicle_reg" required>
        <input type="submit" name="vehicle_reg_submit" value="Search">
    </form>

    <?php if ($vehicle_details): ?>
        <!-- Step 2: Display vehicle details and allow the user to enter the amount paid -->
        <form action="payment.php" method="POST">
            <h2>Vehicle Details:</h2>
            <p>Installation Date: <input type="text" name="INSTALLATION_DATE" value="<?= htmlspecialchars($vehicle_details['INSTALLATION_DATE'] ?? ''); ?>" readonly></p>
            <p>Technician: <input type="text" name="TECHNICIAN" value="<?= htmlspecialchars($vehicle_details['TECHNICIAN'] ?? ''); ?>" readonly></p>
            <p>Client Name: <input type="text" name="CLIENT_NAME" value="<?= htmlspecialchars($vehicle_details['CLIENT_NAME'] ?? ''); ?>" readonly></p>
            <p>Model: <input type="text" name="MODEL" value="<?= htmlspecialchars($vehicle_details['MODEL'] ?? ''); ?>" readonly></p>
            <p>Tracker Number: <input type="text" name="TRACKER_NUMBER" value="<?= htmlspecialchars($vehicle_details['TRACKER_NUMBER'] ?? ''); ?>" readonly></p>
            <p>Contact: <input type="text" name="CONTACT" value="<?= htmlspecialchars($vehicle_details['CONTACT'] ?? ''); ?>" readonly></p>
            <p>Loan Duration: <input type="text" name="LOAN_DURATION" value="<?= htmlspecialchars($vehicle_details['LOAN_DURATION'] ?? ''); ?>" readonly></p>
            <p>Expiray: <input type="text" name="expiray" value="<?= htmlspecialchars($vehicle_details['expiray'] ?? ''); ?>" readonly></p>
            
            <!-- Additional fields for entering payment details -->
            <p>Amount Paid: <input type="text" id="amount_paid" name="amount_paid" required></p>
            
            <input type="hidden" name="vehicle_reg" value="<?= htmlspecialchars($vehicle_reg); ?>">
            <input type="hidden" name="INSTALLATION_DATE" value="<?= htmlspecialchars($vehicle_details['INSTALLATION_DATE']); ?>">
            <input type="hidden" name="CLIENT_NAME" value="<?= htmlspecialchars($vehicle_details['CLIENT_NAME']); ?>">
            <input type="hidden" name="MODEL" value="<?= htmlspecialchars($vehicle_details['MODEL']); ?>">
            <input type="hidden" name="TRACKER_NUMBER" value="<?= htmlspecialchars($vehicle_details['TRACKER_NUMBER']); ?>">
            <input type="hidden" name="CONTACT" value="<?= htmlspecialchars($vehicle_details['CONTACT']); ?>">
            <input type="hidden" name="LOAN_DURATION" value="<?= htmlspecialchars($vehicle_details['LOAN_DURATION']); ?>">
            <input type="hidden" name="expiray" value="<?= htmlspecialchars($vehicle_details['expiray']); ?>">
            <input type="submit" name="save_payment" value="Save Payment">
        </form>
    <?php endif; ?>

    <!-- Button to return to dashboard -->
    <a href="dashboard.php" class="btn-return"><i class="fas fa-arrow-left"></i> Return to Dashboard</a>
</body>
</html>
