



<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete Vehicle Record</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 90%;
            max-width: 800px;
            margin: 50px auto;
            background: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }
        .container h2 {
            text-align: center;
            margin-bottom: 20px;
            font-size: 24px;
            color: #333;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: #555;
        }
        .form-group input {
            width: 100%;
            padding: 10px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .btn, .btn-confirm {
            display: block;
            width: 100%;
            padding: 10px;
            border: none;
            cursor: pointer;
            text-align: center;
            font-size: 16px;
            margin-top: 10px;
            border-radius: 4px;
            color: #fff;
            transition: background-color 0.3s;
        }
        .btn {
            background-color: #dc3545;
        }
        .btn:hover {
            background-color: #c82333;
        }
        .btn-confirm {
            background-color: #28a745;
        }
        .btn-confirm:hover {
            background-color: #218838;
        }
        .record {
            margin-top: 20px;
            padding: 10px;
            background: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 4px;
            display: flex;
            flex-direction: column;
            gap: 5px;
        }
        .record p {
            margin: 0;
        }
        @media (max-width: 600px) {
            .container {
                width: 100%;
                padding: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Delete Vehicle Record</h2>
        <?php
        include "conn.php";

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $search_id = $_POST['search_id'] ?? '';

            if (isset($_POST['confirm_delete'])) {
                // Directly delete the record by ID
                if (!empty($search_id)) {
                    $stmt = $conn->prepare("DELETE FROM record10 WHERE id = ?");
                    $stmt->bind_param("i", $search_id);

                    // Execute the statement
                    if ($stmt->execute()) {
                        if ($stmt->affected_rows > 0) {
                            echo "<p style='color:green;'>Record with ID $search_id deleted successfully</p>";
                        } else {
                            echo "<p style='color:red;'>No record found with ID: " . htmlspecialchars($search_id) . "</p>";
                        }
                    } else {
                        echo "<p style='color:red;'>Error: " . $stmt->error . "</p>";
                    }

                    $stmt->close();
                } else {
                    echo "<p style='color:red;'>No ID provided for deletion</p>";
                }

                $conn->close();
            } else {
                // Prepare and bind
                $stmt = $conn->prepare("SELECT * FROM record10 WHERE id = ?");
                $stmt->bind_param("i", $search_id);

                // Set parameters and execute
                $stmt->execute();
                $result = $stmt->get_result();

                if ($result->num_rows > 0) {
                    $record = $result->fetch_assoc();
                    echo "<form action='' method='POST'>";
                    echo "<input type='hidden' name='search_id' value='" . htmlspecialchars($search_id) . "'>";
                    echo "<div class='record'>";
                    echo "<p><strong>ID:</strong> " . htmlspecialchars($record['id']) . "</p>";
                    echo "<p><strong>INSTALLATION_DATE:</strong> " . htmlspecialchars($record['INSTALLATION_DATE']) . "</p>";
                    echo "<p><strong>CLIENT_NAME:</strong> " . htmlspecialchars($record['CLIENT_NAME']) . "</p>";
                    echo "<p><strong>SALES_PERSON:</strong> " . htmlspecialchars($record['SALES_PERSON']) . "</p>";
                    echo "<p><strong>VEHICLE_REG:</strong> " . htmlspecialchars($record['VEHICLE_REG']) . "</p>";
                    echo "<p><strong>MODEL:</strong> " . htmlspecialchars($record['MODEL']) . "</p>";
                    echo "<p><strong>TRACKER_NUMBER:</strong> " . htmlspecialchars($record['TRACKER_NUMBER']) . "</p>";
                    echo "<p><strong>CONTACT:</strong> " . htmlspecialchars($record['CONTACT']) . "</p>";
                    echo "<p><strong>Bank:</strong> " . htmlspecialchars($record['Bank']) . "</p>";
                    echo "<p><strong>TECHNICIAN:</strong> " . htmlspecialchars($record['TECHNICIAN']) . "</p>";
                    echo "<p><strong>T_K:</strong> " . htmlspecialchars($record['T_K']) . "</p>";
                    echo "<p><strong>Tracksolid:</strong> " . htmlspecialchars($record['Tracksolid']) . "</p>";
                    echo "<p><strong>USERNAME:</strong> " . htmlspecialchars($record['USERNAME']) . "</p>";
                    echo "<p><strong>PASSWORD:</strong> " . htmlspecialchars($record['PASSWORD']) . "</p>";
                    echo "<p><strong>LOAN_DURATION:</strong> " . htmlspecialchars($record['LOAN_DURATION']) . "</p>";
                    echo "<p><strong>C_NO:</strong> " . htmlspecialchars($record['C_NO']) . "</p>";
                    echo "<p><strong>EXPIRY:</strong> " . htmlspecialchars($record['expiray']) . "</p>";
                    echo "</div>";
                    echo "<button type='submit' name='confirm_delete' class='btn btn-confirm'><i class='fas fa-check'></i> Confirm Delete</button>";
                    echo "</form>";
                } else {
                    echo "<p style='color:red;'>No record found for ID: " . htmlspecialchars($search_id) . "</p>";
                }

                $stmt->close();
            }
        }
        ?>
        <form action="" method="POST">
            <div class="form-group">
                <label for="search_id"><i class="fas fa-search"></i> Enter Record ID:</label>
                <input type="text" id="search_id" name="search_id" required>
            </div>
            <button type="submit" class="btn"><i class="fas fa-search"></i> Search</button>
            <a href="dashboard.php" class="btn" style="background-color: brown; border: 2px solid brown; color: #fff; text-decoration: none;"><i class="fas fa-arrow-left"></i> Return To Dashboard</a>
        </form>
    </div>
</body>
</html>
