<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Update Vehicle Records</title>
    <head>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>

    <style>
        body {
            font-family: Arial, sans-serif;
            background: blueviolet;
            color: #333;
            padding: 20px;
            margin: 0;
            box-sizing: border-box;
        }
        h2 {
            text-align: center;
            color: #fff;
            margin-bottom: 30px;
        }
        form {
            margin-bottom: 20px;
            background-color: rgba(255, 255, 255, 0.9);
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            justify-content: space-around;
        }
        .form-group {
            display: flex;
            flex-basis: 48%;
            align-items: center;
            gap: 10px;
            margin: 10px 0;
        }
        .form-group label {
            flex-basis: 40%;
            text-align: right;
            color: #004e92;
        }
        .form-group input, .form-group select {
            flex-basis: 60%;
            padding: 10px;
            border-radius: 5px;
            border: 1px solid #004e92;
        }
        input[type="submit"] {
            padding: 10px 20px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        input[type="submit"]:hover {
            background-color: #0056b3;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background-color: #fff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
        }
        table, th, td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: center;
        }
        th {
            background-color: #f2f2f2;
        }
        .form-container {
            margin: 20px 0;
        }
        .form-container form {
            flex-direction: column;
        }
        .form-container .form-group {
            flex-direction: row;
            align-items: center;
        }
        .form-container .form-group label {
            flex-basis: 30%;
        }
        .form-container .form-group input {
            flex-basis: 70%;
        }
        .form-container .form-group input[type="submit"] {
            flex-basis: auto;
            margin-left: auto;
        }
    </style>
</head>
<body>
    <h2>Update Vehicle Records</h2>

    <div class="form-container">
        <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
            <div class="form-group">
                <label for="vehicleReg">Enter Vehicle Registration Number:</label>
                <input type="text" id="vehicleReg" name="vehicleReg" required>
            </div>
            <input type="submit" value="Fetch Details" name="fetchDetails">
        </form>
 
    </div>

    <?php
    $dbHost = 'localhost';
    $dbName = 'rantovpw_idealtrackrecord';
    $dbUser = 'rantovpw_idealtrack';
    $dbPass = 'P?YjNx%N[XGp';

    // Function to sanitize input data
    function sanitize($data, $conn) {
        return $conn->real_escape_string($data);
    }

    // Function to format date
    function formatDate($date) {
        return date('m/d/Y', strtotime($date));
    }

    // Fetch vehicle details and display them for editing
    if (isset($_POST['fetchDetails'])) {
        $vehicleReg = $_POST['vehicleReg'];

        // Connect to the database
        $conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);

        // Check connection
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // Prepare SQL statement to fetch vehicle details
        $vehicleReg = sanitize($vehicleReg, $conn);
        $sql = "SELECT * FROM record10 WHERE VEHICLE_REG = '$vehicleReg'";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            ?>
            <div class="form-container">
                <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
                    <input type="hidden" name="vehicleReg" value="<?php echo htmlspecialchars($vehicleReg); ?>">
                    <div class="form-group">
                        <label for="installationDate">Installation Date:</label>
                        <input type="text" id="installationDate" name="installationDate" value="<?php echo htmlspecialchars($row['INSTALLATION_DATE']); ?>" >
                    </div>
                    <div class="form-group">
                        <label for="clientName">Client Name:</label>
                        <input type="text" id="clientName" name="clientName" value="<?php echo htmlspecialchars($row['CLIENT_NAME']); ?>" >
                    </div>
                    <div class="form-group">
                        <label for="salesPerson">Sales Person:</label>
                        <input type="text" id="salesPerson" name="salesPerson" value="<?php echo htmlspecialchars($row['SALES_PERSON']); ?>" >
                    </div>
                    <div class="form-group">
                        <label for="trackerNumber">Tracker Number:</label>
                        <input type="text" id="trackerNumber" name="trackerNumber" value="<?php echo htmlspecialchars($row['TRACKER_NUMBER']); ?>" >
                    </div>
                    <div class="form-group">
                        <label for="contact">Contact:</label>
                        <input type="text" id="contact" name="contact" value="<?php echo htmlspecialchars($row['CONTACT']); ?>" >
                    </div>
                    <div class="form-group">
                        <label for="loanDuration">Loan Duration:</label>
                        <input type="text" id="loanDuration" name="loanDuration" value="<?php echo htmlspecialchars($row['LOAN_DURATION']); ?>" >
                    </div>
                    <div class="form-group">
                        <label for="expiray">Expiry Date:</label>
                        <input type="text" id="expiray" name="expiray" value="<?php echo htmlspecialchars($row['expiray']); ?>" re>
                        <p style="background-color: yellow; color: red; font-weight: bold; padding: 10px; border: 2px solid red; display: flex; align-items: center;">
    <span style="margin-right: 10px;">
        <i class="fas fa-exclamation-triangle" style="font-size: 20px;"></i>
    </span>
    Always remember that expiry date is not being calculated automatically. And it's very crucial.
</p>

                    </div>
                    <input type="submit" value="Update Details" name="updateDetails">
                    
                    <p >Always remember that expiray date is not being calculate automatically .And its very crutial</p>
                </form>
            </div>
            <?php
        } else {
            echo '<p style="text-align: center; color: white;">No records found for the provided vehicle registration number.</p>';
        }

        // Close the connection
        $conn->close();
    }

    // Update vehicle details in the database
    if (isset($_POST['updateDetails'])) {
        $vehicleReg = $_POST['vehicleReg'];
        $installationDate = $_POST['installationDate'];
        $clientName = $_POST['clientName'];
        $salesPerson = $_POST['salesPerson'];
        $trackerNumber = $_POST['trackerNumber'];
        $contact = $_POST['contact'];
        $loanDuration = $_POST['loanDuration'];
        $expiray = $_POST['expiray'];

        // Connect to the database
        $conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);

        // Check connection
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // Sanitize input data
        $vehicleReg = sanitize($vehicleReg, $conn);
        $installationDate = sanitize($installationDate, $conn);
        $clientName = sanitize($clientName, $conn);
        $salesPerson = sanitize($salesPerson, $conn);
        $trackerNumber = sanitize($trackerNumber, $conn);
        $contact = sanitize($contact, $conn);
        $loanDuration = sanitize($loanDuration, $conn);
        $expiray = sanitize($expiray, $conn);

        // Prepare SQL statement to update vehicle details
        $sql = "UPDATE record10 SET INSTALLATION_DATE = '$installationDate', CLIENT_NAME = '$clientName', SALES_PERSON = '$salesPerson', TRACKER_NUMBER = '$trackerNumber', CONTACT = '$contact', LOAN_DURATION = '$loanDuration', expiray = '$expiray' WHERE VEHICLE_REG = '$vehicleReg'";

        if ($conn->query($sql) === TRUE) {
            echo '<p style="text-align: center; color: white;">Vehicle details updated successfully.</p>';
        } else {
            echo '<p style="text-align: center; color: white;">Error updating record: ' . $conn->error . '</p>';
        }

        // Close the connection
        $conn->close();
    }
    ?>
</body>
</html>
