<?php
include "conn.php"; // Ensure you have a correct database connection

// Initialize variables for form input
$phone_number = $fullname = '';

// Add Technician
if (isset($_POST['add'])) {
    $phone_number = $_POST['phone_number'];
    $fullname = $_POST['fullname'];

    // Insert new technician into the database
    $sql = "INSERT INTO technician (phone_number, fullname) VALUES (?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $phone_number, $fullname);

    if ($stmt->execute()) {
        echo "<p style='color:green;'>Technician added successfully.</p>";
    } else {
        echo "<p style='color:red;'>Error adding technician: " . $stmt->error . "</p>";
    }
    $stmt->close();
}

// Edit Technician
if (isset($_POST['update'])) {
    $phone_number = $_POST['phone_number'];
    $fullname = $_POST['fullname'];

    // Update technician details in the database
    $sql = "UPDATE technician SET fullname = ? WHERE phone_number = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $fullname, $phone_number);
    
    if ($stmt->execute()) {
        echo "<p style='color:green;'>Technician details updated successfully.</p>";
    } else {
        echo "<p style='color:red;'>Error updating technician details: " . $stmt->error . "</p>";
    }
    $stmt->close();
}

// Delete Technician
if (isset($_POST['delete'])) {
    $phone_number = $_POST['phone_number'];

    // Delete technician from the database
    $sql = "DELETE FROM technician WHERE phone_number = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $phone_number);

    if ($stmt->execute()) {
        echo "<p style='color:green;'>Technician deleted successfully.</p>";
    } else {
        echo "<p style='color:red;'>Error deleting technician: " . $stmt->error . "</p>";
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Technicians</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 90%;
            max-width: 800px;
            margin: 50px auto;
            background: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .container h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
        }
        .form-group input {
            width: 100%;
            padding: 10px;
            box-sizing: border-box;
        }
        .form-group .alert {
            color: red;
            font-size: 14px;
        }
        .btn, .edit-btn, .delete-btn {
            display: block;
            width: 100%;
            padding: 10px;
            border: none;
            cursor: pointer;
        }
        .btn {
            background-color: #007bff;
            color: white;
        }
        .btn:hover {
            background-color: #0056b3;
        }
        .edit-btn {
            background-color: #28a745;
            color: white;
        }
        .edit-btn:hover {
            background-color: #218838;
        }
        .delete-btn {
            background-color: #dc3545;
            color: white;
        }
        .delete-btn:hover {
            background-color: #c82333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #f4f4f4;
        }
        @media (max-width: 600px) {
            .container {
                width: 100%;
                padding: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Manage Technicians</h2>
        <!-- Form for adding or editing technician -->
        <form action="" method="POST">
            <div class="form-group">
                <label for="phone_number"><i class="fas fa-phone"></i> Phone Number</label>
                <input type="text" id="phone_number" name="phone_number" value="<?php echo htmlspecialchars($phone_number); ?>" required>
            </div>
            <div class="form-group">
                <label for="fullname"><i class="fas fa-user"></i> Full Name</label>
                <input type="text" id="fullname" name="fullname" value="<?php echo htmlspecialchars($fullname); ?>" required>
            </div>
            <button type="submit" name="add" class="btn"><i class="fas fa-plus"></i> Add Technician</button>
            <button type="submit" name="update" class="btn"><i class="fas fa-pencil-alt"></i> Update Technician</button>
            <button type="submit" name="delete" class="delete-btn"><i class="fas fa-trash"></i> Delete Technician</button>
        </form>

        <!-- Table displaying technicians -->
        <table>
            <tr>
                <th>Phone Number</th>
                <th>Full Name</th>
                <th>Actions</th>
            </tr>
            <?php
            $sql = "SELECT phone_number, fullname FROM technician";
            $result = $conn->query($sql);
            
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . htmlspecialchars($row['phone_number']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['fullname']) . "</td>";
                    echo "<td>";
                    echo "<form action='' method='POST' style='display:inline;'>";
                    echo "<input type='hidden' name='phone_number' value='" . htmlspecialchars($row['phone_number']) . "'>";
                    echo "<button type='submit' name='edit' class='edit-btn'><i class='fas fa-pencil-alt'></i> Edit</button>";
                    echo "</form>";
                    echo "<form action='' method='POST' style='display:inline;'>";
                    echo "<input type='hidden' name='phone_number' value='" . htmlspecialchars($row['phone_number']) . "'>";
                    echo "<button type='submit' name='delete' class='delete-btn'><i class='fas fa-trash'></i> Delete</button>";
                    echo "</form>";
                    echo "</td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='3'>No technicians found.</td></tr>";
            }
            ?>
        </table>
    </div>
</body>
</html>
