
<?php
// Include the session check
include 'session_check.php'; 
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Vehicle Record</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            background: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            margin: 0 auto;
        }
        .container h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
        }
        .form-group input, .form-group textarea {
            width: 100%;
            padding: 10px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 16px;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 10px;
            background-color: #007bff;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 4px;
            font-size: 16px;
            text-align: center;
        }
        .btn:hover {
            background-color: #0056b3;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #f4f4f4;
        }
        .action-btn {
            display: inline-block;
            padding: 5px 10px;
            margin: 2px;
            font-size: 14px;
            text-decoration: none;
            color: #007bff;
            border: 1px solid #007bff;
            border-radius: 4px;
        }
        .action-btn:hover {
            background-color: #0056b3;
            color: white;
        }
        @media (max-width: 600px) {
            .container {
                padding: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Edit Vehicle Record</h2>
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
            <div class="form-group">
                <label for="vehicle_reg"><i class="fas fa-car"></i> Vehicle Registration Number</label>
                <input type="text" id="vehicle_reg" name="vehicle_reg" value="<?php echo htmlspecialchars($_POST['vehicle_reg'] ?? ''); ?>" required>
            </div>
            <button type="submit" name="fetch_records" class="btn"><i class="fas fa-search"></i> Fetch Records</button>
            <a href="dashboard.php" class="btn" style="background-color: brown;"><i class="fas fa-arrow-left"></i> Return To Dashboard</a>
        </form>

        <?php
        include "conn.php"; // Include your database connection file

        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['fetch_records'])) {
            $vehicle_reg = $_POST['vehicle_reg'];

            // Prepared statement to fetch all records
            $stmt = $conn->prepare("SELECT * FROM record10 WHERE VEHICLE_REG = ?");
            $stmt->bind_param("s", $vehicle_reg);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                echo '<table>
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Client Name</th>
                                <th>Model</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>';

                while ($row = $result->fetch_assoc()) {
                    echo '<tr>
                            <td>' . htmlspecialchars($row['ID']) . '</td>
                            <td>' . htmlspecialchars($row['CLIENT_NAME']) . '</td>
                            <td>' . htmlspecialchars($row['MODEL']) . '</td>
                            <td><a href="?edit_id=' . htmlspecialchars($row['ID']) . '" class="action-btn"><i class="fas fa-edit"></i> Edit</a></td>
                        </tr>';
                }

                echo '</tbody></table>';
            } else {
                echo "<p>No records found for vehicle registration number: $vehicle_reg</p>";
            }
            $stmt->close();
        }

        if (isset($_GET['edit_id'])) {
            $edit_id = $_GET['edit_id'];

            // Prepared statement to fetch the specific record
            $stmt = $conn->prepare("SELECT * FROM record10 WHERE ID = ?");
            $stmt->bind_param("i", $edit_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $row = $result->fetch_assoc();

            if ($row) {
                ?>
                <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST">
                    <input type="hidden" name="edit_id" value="<?php echo htmlspecialchars($row['ID']); ?>">
                    <!-- Include all other fields with values from $row -->
                    <div class="form-group">
                        <label for="installation_date"><i class="fas fa-calendar-alt"></i> Installation Date (mm/dd/yyyy)</label>
                        <input type="text" id="installation_date" name="installation_date" value="<?php echo htmlspecialchars($row['INSTALLATION_DATE']); ?>">
                    </div>
                    <!-- Add more fields as needed -->
                    <button type="submit" name="update_record" class="btn"><i class="fas fa-save"></i> Save Changes</button>
                </form>
                <?php
            } else {
                echo "<p>No record found for ID: $edit_id</p>";
            }
            $stmt->close();
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_record'])) {
            $edit_id = $_POST['edit_id'];
            // Retrieve updated values
            $installation_date = $_POST['installation_date'];
            // Include other fields as needed

            // Ensure dates are in mm/dd/yyyy format
            $installation_date = date('m/d/Y', strtotime($installation_date));

            // Prepared statement for update
            $stmt = $conn->prepare("UPDATE record10 SET 
                INSTALLATION_DATE = ?,
                CLIENT_NAME = ?, 
                SALES_PERSON = ?, 
                MODEL = ?, 
                TRACKER_NUMBER = ?, 
                CONTACT = ?, 
                Bank = ?, 
                TECHNICIAN = ?, 
                T_K = ?, 
                Tracksolid = ?, 
                USERNAME = ?, 
                PASSWORD = ?, 
                LOAN_DURATION = ?, 
                C_NO = ?, 
                expiray = ? 
                WHERE ID = ?");
            $stmt->bind_param("ssssssssssssssi", $installation_date, $client_name, $sales_person, $model, $tracker_number, $contact, $bank, $technician, $t_k, $tracksolid, $username, $password, $loan_duration, $c_no, $expiray, $edit_id);

            if ($stmt->execute()) {
                echo '<div style="background: #d4edda; color: #155724; border: 1px solid #c3e6cb; padding: 10px; margin-top: 10px;">Record updated successfully.</div>';
            } else {
                echo '<div style="background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; padding: 10px; margin-top: 10px;">Error updating record: ' . $stmt->error . '</div>';
            }
            $stmt->close();
        }

        $conn->close();
        ?>
    </div>
</body>
</html>
