<?php
session_start(); // Start the session

// Check if user is logged in; if not, redirect to login page

// Include your database connection
include "conn.php";

// Initialize variables to hold form input
$installation_date = $client_name = $sales_person = $vehicle_reg = $model = $tracker_number = $contact = $bank = $bank_branch = $technician = $t_k = $tracksolid = $username = $password = $loan_duration = $c_no = $expiray = $imei = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $installation_date = $_POST['installation_date'];
    $client_name = $_POST['client_name'];
    $sales_person = $_POST['sales_person'];
    $vehicle_reg = $_POST['vehicle_reg'];
    $model = $_POST['model'];
    $tracker_number = $_POST['tracker_number'];
    $contact = $_POST['contact'];
    $bank = $_POST['bank'];
     $bank_branch = $_POST['bank_branch']; // New field
    $technician_phone = $_POST['technician'];
    $t_k = $_POST['t_k'];
    $tracksolid = $_POST['tracksolid'];
    $username = $_POST['username'];
    $password = $_POST['password'];
    $loan_duration = $_POST['loan_duration'];
    $c_no = $_POST['c_no'];
    $expiray = $_POST['expiray'];
    $imei = $_POST['imei'];
    $tracker_location = $_POST['tracker_location'];


    // Fetch the full name of the technician based on the phone number
    $tech_query = "SELECT full_name FROM technician WHERE phone_number = ?";
    $stmt = $conn->prepare($tech_query);
    $stmt->bind_param("s", $technician_phone);
    $stmt->execute();
    $stmt->bind_result($technician);
    $stmt->fetch();
    $stmt->close();

    // Format dates to mm/dd/yyyy for MySQL storage, allow empty dates
    $formatted_installation_date = !empty($installation_date) ? date('m/d/Y', strtotime($installation_date)) : '';
    $formatted_expiray = !empty($expiray) ? date('m/d/Y', strtotime($expiray)) : '';

    // Use prepared statement for insertion
    $sql = "INSERT INTO record10 (INSTALLATION_DATE, CLIENT_NAME, SALES_PERSON, VEHICLE_REG, MODEL, TRACKER_NUMBER, CONTACT, Bank,Bank_Branch, TECHNICIAN, T_K, Tracksolid, USERNAME, PASSWORD, LOAN_DURATION, C_NO, expiray, IMEI,Tracker_Location)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?,?)";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssssssssssssssss",
        $formatted_installation_date,
        $client_name,
        $sales_person,
        $vehicle_reg,
        $model,
        $tracker_number,
        $contact,
        $bank,
        $bank_branch, // Bind the new field
        $technician,
        $t_k,
        $tracksolid,
        $username,
        $password,
        $loan_duration,
        $c_no,
        $formatted_expiray,
        $imei,
        $tracker_location // Bind the new field
    );

    if ($stmt->execute()) {
        echo "<p class='alert success'>New record created successfully</p>";
        // Clear input fields after successful insertion
        $installation_date = $client_name = $sales_person = $vehicle_reg = $model = $tracker_number = $contact = $bank = $bank_branch = $technician = $t_k = $tracksolid = $username = $password = $loan_duration = $c_no = $expiray = $imei = $tracker_location ='';
    } else {
        echo "<p class='alert error'>Error: " . $stmt->error . "</p>";
    }
    $stmt->close();
}

// Fetch sales persons for dropdown
$sales_query = "SELECT phone_number, full_name FROM sales_person";
$sales_result = $conn->query($sales_query);

// Fetch technicians for dropdown
$tech_query = "SELECT phone_number, full_name FROM technician";
$tech_result = $conn->query($tech_query);
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Insert Vehicle Record</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="styles.css"> <!-- Link to your CSS file -->
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <style>
        /* Your existing styles here */
       body {
    font-family: Arial, sans-serif;
    background-color: #f0f2f5;
    margin: 0;
    padding: 0;
}

.container {
    width: 90%;
    max-width: 1200px;
    height: 90vh; /* Ensure the container fits within the viewport height */
    margin: 20px auto;
    background: #ffffff;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    border: 1px solid #e0e0e0;
    display: flex;
    flex-direction: column;
    justify-content: flex-start; /* Align items to the start */
    overflow-y: auto; /* Enable vertical scrolling if needed */
}

.container h2 {
    text-align: center;
    color: #333;
    margin-bottom: 20px;
    font-size: 24px;
    border-bottom: 2px solid #007bff;
    padding-bottom: 10px;
}

.form-row {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
}

.form-group {
    flex: 1 1 calc(50% - 20px); /* Two columns with spacing */
    min-width: 300px; /* Minimum width for each column */
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: bold;
    color: #555;
}

.form-group input, .form-group select {
    width: 100%;
    padding: 12px;
    border-radius: 4px;
    border: 1px solid #ccc;
    box-sizing: border-box;
    font-size: 16px;
    margin-bottom: 10px;
}

.form-group input:focus, .form-group select:focus {
    border-color: #007bff;
    outline: none;
    box-shadow: 0 0 5px rgba(0, 123, 255, 0.2);
}

.form-group i {
    color: #007bff;
    margin-right: 8px;
}

.btn {
    display: block;
    width: 100%;
    padding: 15px;
    background-color: #007bff;
    color: white;
    border: none;
    border-radius: 4px;
    font-size: 16px;
    cursor: pointer;
    transition: background-color 0.3s ease;
    margin-top: 20px;
}

.btn:hover {
    background-color: #0056b3;
}

.alert {
    padding: 10px;
    border-radius: 4px;
    margin-bottom: 20px;
}

.alert.success {
    background-color: #d4edda;
    color: #155724;
}

.alert.error {
    background-color: #f8d7da;
    color: #721c24;
}

@media (max-width: 768px) {
    .form-group {
        flex: 1 1 100%; /* Stack form groups on smaller screens */
        margin: 5px 0;
    }
}


    </style>
    <script>
        $(function() {
            // Initialize datepicker
            $("#installation_date").datepicker({
                dateFormat: "mm/dd/yy",
                changeMonth: true,
                changeYear: true
            });

            $("#expiray").datepicker({
                dateFormat: "mm/dd/yy",
                changeMonth: true,
                changeYear: true
            });
        });
    </script>
</head>
<body>
    <div class="container">
        <h2>Insert Vehicle Record</h2>
       <form action="" method="POST">
    <div class="form-row">
        <div class="form-group">
            <label for="installation_date"><i class="fas fa-calendar-alt"></i> Installation Date</label>
            <input type="text" id="installation_date" name="installation_date" placeholder="mm/dd/yyyy" value="<?php echo htmlspecialchars($installation_date); ?>" required>
        </div>
        <div class="form-group">
            <label for="client_name"><i class="fas fa-user"></i> Client Name</label>
            <input type="text" id="client_name" name="client_name" value="<?php echo htmlspecialchars($client_name); ?>" required>
        </div>
    </div>
    <div class="form-row">
        <div class="form-group">
            <label for="sales_person"><i class="fas fa-user-tie"></i> Sales Person</label>
            <select id="sales_person" name="sales_person" required>
                <?php while ($row = $sales_result->fetch_assoc()): ?>
                    <option value="<?php echo htmlspecialchars($row['full_name']); ?>" <?php if ($sales_person === $row['full_name']) echo 'selected'; ?>><?php echo htmlspecialchars($row['full_name']); ?></option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="vehicle_reg"><i class="fas fa-car"></i> Vehicle Reg</label>
            <input type="text" id="vehicle_reg" name="vehicle_reg" value="<?php echo htmlspecialchars($vehicle_reg); ?>" required>
        </div>
    </div>
    <div class="form-row">
        <div class="form-group">
            <label for="model"><i class="fas fa-car-side"></i> Model</label>
            <input type="text" id="model" name="model" value="<?php echo htmlspecialchars($model); ?>" required>
        </div>
        <div class="form-group">
            <label for="tracker_number"><i class="fas fa-map-marker-alt"></i> Tracker Number</label>
            <input type="text" id="tracker_number" name="tracker_number" value="<?php echo htmlspecialchars($tracker_number); ?>" required>
        </div>
    </div>
    <div class="form-row">
        <div class="form-group">
            <label for="contact"><i class="fas fa-phone"></i> Contact</label>
            <input type="text" id="contact" name="contact" value="<?php echo htmlspecialchars($contact); ?>" >
        </div>
        <div class="form-group">
            <label for="bank"><i class="fas fa-university"></i> Bank</label>
            <input type="text" id="bank" name="bank" value="<?php echo htmlspecialchars($bank); ?>" required>
        </div>
    </div>
    <div class="form-row">
        <div class="form-group">
            <label for="bank_branch"><i class="fas fa-building"></i> Bank Branch</label>
            <input type="text" id="bank_branch" name="bank_branch" value="<?php echo htmlspecialchars($bank_branch); ?>">
        </div>
        <div class="form-group">
            <label for="tracker_location"><i class="fas fa-map-marker-alt"></i> Tracker Location</label>
            <input type="text" id="tracker_location" name="tracker_location" value="<?php echo htmlspecialchars($tracker_location); ?>" required>
        </div>
    </div>
    <div class="form-row">
        <div class="form-group">
            <label for="technician"><i class="fas fa-user-cog"></i> Technician</label>
            <select id="technician" name="technician" required>
                <?php while ($row = $tech_result->fetch_assoc()): ?>
                    <option value="<?php echo htmlspecialchars($row['phone_number']); ?>" <?php if ($technician_phone === $row['phone_number']) echo 'selected'; ?>><?php echo htmlspecialchars($row['full_name']); ?></option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="t_k"><i class="fas fa-key"></i> T K</label>
            <input type="text" id="t_k" name="t_k" value="<?php echo htmlspecialchars($t_k); ?>" required>
        </div>
    </div>
    <div class="form-row">
        <div class="form-group">
            <label for="tracksolid"><i class="fas fa-map"></i> Tracksolid</label>
            <input type="text" id="tracksolid" name="tracksolid" value="<?php echo htmlspecialchars($tracksolid); ?>" required>
        </div>
        <div class="form-group">
            <label for="username"><i class="fas fa-user-circle"></i> Username</label>
            <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($username); ?>" required>
        </div>
    </div>
    <div class="form-row">
        <div class="form-group">
            <label for="password"><i class="fas fa-lock"></i> Password</label>
            <input type="text" id="password" name="password" value="<?php echo htmlspecialchars($password); ?>" required>
        </div>
        <div class="form-group">
            <label for="loan_duration"><i class="fas fa-calendar"></i> Loan Duration</label>
            <input type="text" id="loan_duration" name="loan_duration" value="<?php echo htmlspecialchars($loan_duration); ?>" required>
        </div>
    </div>
    <div class="form-row">
        <div class="form-group">
            <label for="c_no"><i class="fas fa-hashtag"></i> C NO</label>
            <input type="text" id="c_no" name="c_no" value="<?php echo htmlspecialchars($c_no); ?>" >
        </div>
        <div class="form-group">
            <label for="expiray"><i class="fas fa-calendar-alt"></i> Expiry</label>
            <input type="text" id="expiray" name="expiray" placeholder="mm/dd/yyyy" value="<?php echo htmlspecialchars($expiray); ?>" required>
        </div>
        <div class="form-group">
            <label for="imei"><i class="fas fa-barcode"></i> IMEI</label>
            <input type="text" id="imei" name="imei" value="<?php echo htmlspecialchars($imei); ?>" required>
        </div>
    </div>
    <button type="submit" class="btn"><i class="fas fa-save"></i> Insert Record</button>
    <a href="dashboard.php" style="display: inline-block; padding: 10px 20px; margin-top: 10px; font-size: 16px; text-decoration: none; color: #fff; background-color: brown; border-radius: 5px; text-align: center; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); transition: background-color 0.3s ease;">Return To Dashboard</a>
</form>

    </div>
    <script>
    document.querySelector('form').addEventListener('submit', function() {
        document.querySelector('button[type="submit"]').disabled = true;
    });
</script>

</body>
</html>
