<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vehicle Renewals</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 100%;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .search-container {
            margin-bottom: 20px;
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            align-items: center;
        }
        .search-container input[type=text] {
            padding: 10px;
            font-size: 14px;
            border: 1px solid #ccc;
            border-radius: 4px;
            flex: 1;
            background: #f9f9f9;
        }
        .search-container button {
            padding: 10px 15px;
            font-size: 14px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            color: #fff;
            background: #007bff;
            transition: background-color 0.3s ease;
        }
        .search-container button:hover {
            background: #0056b3;
        }
        .reset-button {
            background-color: #dc3545;
        }
        .reset-button:hover {
            background-color: #c82333;
        }
        .back-button {
            display: block;
            margin: 20px auto;
            text-align: center;
        }
        .back-button a {
            display: inline-block;
            padding: 10px 20px;
            font-size: 14px;
            border: none;
            border-radius: 4px;
            color: #fff;
            background: #6c757d;
            text-decoration: none;
            transition: background-color 0.3s ease;
        }
        .back-button a:hover {
            background: #5a6268;
        }
        .table-wrapper {
            max-width: 100%;
            overflow-x: auto;
            position: relative;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 12px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .fixed-header thead th {
            position: sticky;
            top: 0;
            background: #fff;
            z-index: 1;
        }
        @media (max-width: 768px) {
            .search-container {
                flex-direction: column;
            }
            .search-container input[type=text], .search-container button {
                width: 100%;
            }
            .back-button a {
                display: block;
                margin: 10px auto;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Vehicle Renewals</h2>

        <div class="search-container">
            <form action="" method="POST">
                <input type="text" placeholder="Search by Vehicle Registration Number" name="search">
                <button type="submit"><i class="fa fa-search"></i> Search</button>
                <button type="button" class="reset-button" onclick="window.location.href='renewals.php'">Reset</button>
            </form>
        </div>

        <div class="table-wrapper">
            <table class="fixed-header">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Vehicle Registration Number</th>
                        <th>Installation Date</th>
                        <th>Date Renewed</th>
                         <th>Expiry Date</th>
                        <th>Description</th>
                        <th>Client Name</th>
                        <th>Sales Person</th>
                        <th>Model</th>
                        <th>Tracker Number</th>
                        <th>Contact</th>
                        <th>Financia</th>
                        <th>Technician</th>
                        <th>T.K</th>
                        <th>Tracksolid</th>
                        <th>Username</th>
                        <th>Password</th>
                        <th>Loan Duration</th>
                        <th>C/NO</th>
                      
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Database connection
                    include "conn.php";

                    // Initialize variables
                    $search = "";
                    $sql = "";

                    // Process search query
                    if ($_SERVER["REQUEST_METHOD"] == "POST") {
                        $search = $_POST['search'];
                        $sql = "SELECT * FROM renewed_records WHERE VEHICLE_REG LIKE '%$search%'";
                    } else {
                        $sql = "SELECT * FROM renewed_records";
                    }

                    // Execute SQL query
                    $result = $conn->query($sql);

                    // Display results
                    if ($result->num_rows > 0) {
                        $count = 1;
                        while($row = $result->fetch_assoc()) {
                            ?>
                            <tr>
                                <td><?php echo $count++; ?></td>
                                <td><?php echo htmlspecialchars($row['VEHICLE_REG']); ?></td>
                                <td><?php echo htmlspecialchars($row['INSTALLATION_DATE']); ?></td>
                                <td><?php echo htmlspecialchars($row['date_renewed']); ?></td>
                                <td><?php echo htmlspecialchars($row['expiray']); ?></td>
                                <td><?php echo htmlspecialchars($row['description']); ?></td>
                                <td><?php echo htmlspecialchars($row['CLIENT_NAME']); ?></td>
                                <td><?php echo htmlspecialchars($row['SALES_PERSON']); ?></td>
                                <td><?php echo htmlspecialchars($row['MODEL']); ?></td>
                                <td><?php echo htmlspecialchars($row['TRACKER_NUMBER']); ?></td>
                                <td><?php echo htmlspecialchars($row['CONTACT']); ?></td>
                                <td><?php echo htmlspecialchars($row['Finacia']); ?></td>
                                <td><?php echo htmlspecialchars($row['TECHNICIAN']); ?></td>
                                <td><?php echo htmlspecialchars($row['T_K']); ?></td>
                                <td><?php echo htmlspecialchars($row['Tracksolid']); ?></td>
                                <td><?php echo htmlspecialchars($row['USERNAME']); ?></td>
                                <td><?php echo htmlspecialchars($row['PASSWORD']); ?></td>
                                <td><?php echo htmlspecialchars($row['LOAN_DURATION']); ?></td>
                                <td><?php echo htmlspecialchars($row['C_NO']); ?></td>
                                
                            </tr>
                            <?php
                        }
                    } else {
                        echo "<tr><td colspan='18'>No records found</td></tr>";
                    }
                    // Close connection
                    $conn->close();
                    ?>
                </tbody>
            </table>
        </div>

        <div class="back-button">
            <a href="dashboard.php"><i class="fas fa-arrow-left"></i> Back to Dashboard</a>
        </div>
    </div>
</body>
</html>
