<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['file'])) {
    $file = $_FILES['file'];

    // Check if the file is uploaded without errors
    if ($file['error'] == UPLOAD_ERR_OK) {
        $filePath = $file['tmp_name'];

        // Read the content of the file
        $content = file_get_contents($filePath);
        
        // Replace 'ideal' (case-insensitive) with 'fine mark'
        $modifiedContent = preg_replace('/\bideal\b/i', 'fine mark', $content);

        // Prepare the download
        $newFileName = 'modified_' . $file['name'];
        header('Content-Type: text/plain');
        header('Content-Disposition: attachment; filename="' . $newFileName . '"');
        echo $modifiedContent;
        exit;
    } else {
        echo "Error uploading file.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Text Replacement Tool</title>
</head>
<body>
    <h1>Upload File to Replace Text</h1>
    <form method="post" enctype="multipart/form-data">
        <input type="file" name="file" required>
        <input type="submit" value="Upload and Replace">
    </form>
</body>
</html>
