<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Define variables and initialize with empty values
$to = $subject = $message = '';
$to_err = $subject_err = $message_err = '';

// Processing form data when form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate email
    if (empty(trim($_POST["to"])) || !filter_var(trim($_POST["to"]), FILTER_VALIDATE_EMAIL)) {
        $to_err = 'Please enter a valid email address.';
    } else {
        $to = trim($_POST["to"]);
    }

    // Validate subject
    if (empty(trim($_POST["subject"]))) {
        $subject_err = 'Please enter a subject.';
    } else {
        $subject = trim($_POST["subject"]);
    }

    // Validate message
    if (empty(trim($_POST["message"]))) {
        $message_err = 'Please enter a message.';
    } else {
        $message = trim($_POST["message"]);
    }

    // Check input errors before sending email
    if (empty($to_err) && empty($subject_err) && empty($message_err)) {
        // Email headers
        $headers = "From: test@finemarktracking.co.ke\r\n";
        $headers .= "Reply-To: test@finemarktracking.co.ke\r\n";
        $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

        // Send email
        if (mail($to, $subject, $message, $headers)) {
            echo 'Email sent successfully.';
        } else {
            echo 'Failed to send email.';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Send Email</title>
</head>
<body>
    <h1>Send Email</h1>
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <label for="to">Recipient Email:</label>
        <input type="email" id="to" name="to" value="<?php echo htmlspecialchars($to); ?>" required>
        <span><?php echo $to_err; ?></span><br><br>

        <label for="subject">Subject:</label>
        <input type="text" id="subject" name="subject" value="<?php echo htmlspecialchars($subject); ?>" required>
        <span><?php echo $subject_err; ?></span><br><br>

        <label for="message">Message:</label><br>
        <textarea id="message" name="message" rows="4" cols="50" required><?php echo htmlspecialchars($message); ?></textarea>
        <span><?php echo $message_err; ?></span><br><br>

        <input type="submit" value="Send Email">
    </form>
</body>
</html>
