<?php
// Start output buffering and session
ob_start();
session_start();

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit();
}

$access_level = $_SESSION['access_level'];

$vehicle_reg = isset($_GET['vehicle_reg']) ? $_GET['vehicle_reg'] : '';
$client_name = isset($_GET['client_name']) ? $_GET['client_name'] : '';
$tracker_number = isset($_GET['tracker_number']) ? $_GET['tracker_number'] : '';
?>
<!DOCTYPE html>
<html>
<head>
    <title>Search Vehicle Details</title>
    <style>
        /* Global styles */
        body {
            font-family: Arial, sans-serif;
            padding: 10px;
            background-color: lavender;
        }

        /* Form styles */
        form {
            margin-bottom: 20px;
            text-align: center;
        }

        label {
            font-weight: bold;
        }

        input[type="text"], input[type="submit"], input[type="reset"] {
            padding: 8px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        input[type="submit"], input[type="reset"] {
            background-color: #4CAF50;
            color: white;
            cursor: pointer;
            margin-left: 10px;
        }

        input[type="submit"]:hover, input[type="reset"]:hover {
            background-color: #45a049;
        }

        /* Table styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background-color: #ffffff;
            box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2);
        }

        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #4CAF50;
            color: white;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        tr:hover {
            background-color: #e7e7e7;
        }

        /* Header style */
        h2 {
            color: darkblue;
            text-align: center;
            font-size: 19px;
        }

        /* Message style */
        .message {
            margin-top: 20px;
            padding: 10px;
            background-color: #f44336;
            color: white;
            border-radius: 4px;
            text-align: center;
        }

        /* Home button style */
        .home-button {
            display: inline-block;
            padding: 10px 20px;
            font-size: 16px;
            text-decoration: none;
            color: #fff;
            background-color: #2670b9;
            border-radius: 5px;
            text-align: center;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            transition: background-color 0.3s ease;
        }

        .home-button:hover {
            background-color: #1a549a;
        }
    </style>
</head>
<body>
    <h2>Ideal Tracking</h2>
    <h2>Tracker Installation Record</h2>
    <form action="search.php" method="get">
        <input type="text" id="vehicle_reg" name="vehicle_reg" placeholder="Enter Vehicle REG" value="<?php echo isset($_GET['vehicle_reg']) ? htmlspecialchars($_GET['vehicle_reg']) : ''; ?>">
        <input type="text" id="client_name" name="client_name" placeholder="Enter Client Name" value="<?php echo isset($_GET['client_name']) ? htmlspecialchars($_GET['client_name']) : ''; ?>">
        <input type="text" id="tracker_number" name="tracker_number" placeholder="Enter Tracker Number" value="<?php echo isset($_GET['tracker_number']) ? htmlspecialchars($_GET['tracker_number']) : ''; ?>">
        <input type="submit" value="Search">
        <input type="reset" value="Reset" onclick="window.location.href='search.php';">
        <a href="dashboard.php" class="home-button">Home</a>
    </form>

    <?php
    if ($vehicle_reg || $client_name || $tracker_number) {
        include "conn.php";

        // Prepare SQL statement to fetch unique vehicle details
        $sql = "SELECT DISTINCT VEHICLE_REG, INSTALLATION_DATE, CLIENT_NAME, SALES_PERSON, VEHICLE_REG, MODEL, TRACKER_NUMBER, CONTACT, USERNAME, PASSWORD, Finacia, TECHNICIAN, T_K, Tracksolid, LOAN_DURATION, C_NO FROM record2 WHERE 1=1";
        
        if ($vehicle_reg) {
            $sql .= " AND VEHICLE_REG LIKE '%" . $conn->real_escape_string($vehicle_reg) . "%'";
        }
        
        if ($client_name) {
            $sql .= " AND CLIENT_NAME LIKE '%" . $conn->real_escape_string($client_name) . "%'";
        }
        
        if ($tracker_number) {
            $sql .= " AND TRACKER_NUMBER LIKE '%" . $conn->real_escape_string($tracker_number) . "%'";
        }

        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            // Display results in a table
            echo "<table>";
            echo "<tr><th>#</th><th>Installation Date</th><th>Client Name</th><th>Sales Person</th><th>Vehicle Registration</th><th>Model</th><th>Tracker Number</th>";
            
            // Conditional display of columns based on access level
            if ($access_level !== 'Support') {
                echo "<th>Contact</th>";
                echo "<th>Username</th>";
                echo "<th>Password</th>";
            }
            
            echo "<th>Finacia</th><th>Technician</th><th>T.K</th><th>Tracksolid</th><th>Loan Duration</th><th>C/No.</th></tr>";
            
            $count = 1; // Initialize row counter
            
            while ($row = $result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . $count++ . "</td>"; // Column number
                echo "<td>" . htmlspecialchars($row['INSTALLATION_DATE']) . "</td>";
                echo "<td>" . htmlspecialchars($row['CLIENT_NAME']) . "</td>";
                echo "<td>" . htmlspecialchars($row['SALES_PERSON']) . "</td>";
                echo "<td>" . htmlspecialchars($row['VEHICLE_REG']) . "</td>";
                echo "<td>" . htmlspecialchars($row['MODEL']) . "</td>";
                echo "<td>" . htmlspecialchars($row['TRACKER_NUMBER']) . "</td>";
                
                // Conditional display of columns based on access level
                if ($access_level !== 'Support') {
                    echo "<td>" . htmlspecialchars($row['CONTACT']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['USERNAME']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['PASSWORD']) . "</td>";
                }
                
                echo "<td>" . htmlspecialchars($row['Finacia']) . "</td>";
                echo "<td>" . htmlspecialchars($row['TECHNICIAN']) . "</td>";
                echo "<td>" . htmlspecialchars($row['T_K']) . "</td>";
                echo "<td>" . htmlspecialchars($row['Tracksolid']) . "</td>";
                echo "<td>" . htmlspecialchars($row['LOAN_DURATION']) . "</td>";
                echo "<td>" . htmlspecialchars($row['C_NO']) . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<div class='message'>No results found for the provided search criteria.</div>";
        }

        // Close connection
        $conn->close();
    }
    ?>
</body>
</html>
<?php
// End output buffering and flush
ob_end_flush();
?>
