<?php
session_start();

// Include the database connection file
include('conn.php');

// Check if the user is logged in
if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    header('Location: technician_login.php'); // Redirect to login page if not logged in
    exit();
}

// Retrieve logged-in technician's phone number from the session
$phone_number = $_SESSION['phone_number'];

$stmt = $conn->prepare("SELECT full_name FROM technician WHERE phone_number = ?");
$stmt->bind_param("s", $phone_number);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $technician = $result->fetch_assoc();
    $full_name = htmlspecialchars($technician['full_name']);
} else {
    // Technician not found, log out and redirect to login page
    session_destroy();
    header('Location: technician_login.php');
    exit();
}
$stmt->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Technician Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f2f2f2;
            margin: 0;
            padding: 0;
            display: flex;
            height: 100vh;
            overflow: hidden;
        }
        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: white;
            display: flex;
            flex-direction: column;
            position: fixed;
            top: 0;
            bottom: 0;
            left: 0;
            padding: 20px;
            transform: translateX(0);
            transition: transform 0.3s ease-in-out, width 0.3s ease-in-out;
            box-shadow: 2px 0 5px rgba(0,0,0,0.1);
        }
        .sidebar h2 {
            text-align: center;
            margin-bottom: 30px;
            font-size: 24px;
            font-weight: bold;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        .sidebar a {
            color: white;
            padding: 15px;
            text-decoration: none;
            font-size: 18px;
            display: flex;
            align-items: center;
            border-radius: 4px;
            margin: 5px 0;
            transition: background-color 0.3s, transform 0.3s;
        }
        .sidebar a:hover {
            background-color: #34495e;
            transform: translateX(10px);
        }
        .sidebar a .fas {
            margin-right: 10px;
        }
        .sidebar .logout {
            background-color: #e74c3c;
        }
        .sidebar .logout:hover {
            background-color: #c0392b;
        }
       .main-content {
    margin-left: 290px;
    padding: 20px;
    flex-grow: 1;
    background-color:white;
    overflow-y: auto;
    transition: margin-left 0.3s ease-in-out;
    background-image: url('ideallogo.jpeg'); /* Replace with your background image URL */
    background-size: 600px;
    background-position: center;
    background-repeat: no-repeat;
    text-align:center;
}

        .main-content h1 {
            font-size: 32px;
            margin-bottom: 20px;
            color: #2c3e50;
            text-transform: uppercase;
            letter-spacing: 2px;
            animation: fadeIn 1s ease-in-out;
        }
        .main-content p {
            font-size: 18px;
            color: #34495e;
            animation: fadeIn 1.5s ease-in-out;
        }
        .sidebar-toggle {
            display: none;
            position: absolute;
            top: 20px;
            left: 20px;
            font-size: 24px;
            color: #333;
            cursor: pointer;
            z-index: 1000;
        }
        .sidebar-close {
            display: none;
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 24px;
            color: white;
            cursor: pointer;
        }
        @media (max-width: 768px) {
            .sidebar {
                width: 200px;
            }
            .main-content {
                margin-left: 200px;
            }
        }
        @media (max-width: 576px) {
            .sidebar {
                transform: translateX(-100%);
            }
            .main-content {
                margin-left: 0;
            }
            .sidebar-toggle {
                display: block;
            }
            .sidebar.show {
                transform: translateX(0);
            }
            .sidebar.show .sidebar-close {
                display: block;
            }
        }
        @keyframes fadeIn {
            from {
                opacity: 0;
            }
            to {
                opacity: 1;
            }
        }
    </style>
</head>
<body>
    <div class="sidebar-toggle" onclick="toggleSidebar()"><i class="fas fa-bars"></i></div>
    <div class="sidebar" id="sidebar">
        <div class="sidebar-close" onclick="toggleSidebar()"><i class="fas fa-times"></i></div>
        <h2>Dashboard</h2>
        <a href="manage_checkups.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
        <a href="page2.php"><i class="fas fa-user"></i> Profile</a>
        <a href="page3.php"><i class="fas fa-cogs"></i> Settings</a>
        <a href="page4.php"><i class="fas fa-list"></i> Reports</a>
        <a href="page5.php"><i class="fas fa-chart-bar"></i> Analytics</a>
        <a href="page6.php"><i class="fas fa-envelope"></i> Messages</a>
        <a href="page7.php"><i class="fas fa-calendar-alt"></i> Calendar</a>
        <a href="page8.php"><i class="fas fa-file-alt"></i> Documents</a>
        <a href="page9.php"><i class="fas fa-users"></i> Clients</a>
        <a href="page10.php" class="logout"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>
    <div class="main-content">
        <h1>Welcome, <?php echo $full_name; ?></h1>
        <p>Security In Every Mile</p>
    </div>
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('show');
        }
    </script>
</body>
</html>
