<?php
// Include the database connection file
include('conn.php');

session_start();
$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve user input
    $phone_number = trim($_POST['phone_number']);
    $full_name = trim($_POST['full_name']);

    // Prepare and execute SQL query
    $stmt = $conn->prepare("SELECT * FROM technician WHERE phone_number = ? AND full_name = ?");
    $stmt->bind_param("ss", $phone_number, $full_name);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Login successful
        $_SESSION['logged_in'] = true;
        $_SESSION['phone_number'] = $phone_number;
        header('Location: technician_dashboard.php'); // Redirect to dashboard or any other page
        exit();
    } else {
        // Login failed
        $error = 'Invalid phone number or full name.';
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Technician Login</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f2f2f2;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .login-container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
        }
        .login-container h2 {
            margin: 0 0 20px;
            font-size: 24px;
            text-align: center;
        }
        .login-container label {
            display: block;
            margin-bottom: 8px;
        }
        .login-container input {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        .login-container input[type="submit"] {
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
        }
        .login-container input[type="submit"]:hover {
            background-color: #45a049;
        }
        .error {
            color: red;
            text-align: center;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Technician Login</h2>
        <?php if ($error): ?>
            <div class="error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <form action="technician_login.php" method="post">
            <label for="phone_number">Phone Number:</label>
            <input type="text" id="phone_number" name="phone_number" required>

            <label for="full_name">Full Name:</label>
            <input type="text" id="full_name" name="full_name" required>

            <input type="submit" value="Login">
        </form>
    </div>
</body>
</html>
