<?php
include 'conn.php'; // Include the database connection

session_start(); // Start the session

// Initialize variables
$start_id = 	
13213;

// Prepare and execute the query to find unpaid installations
$query = "
    SELECT r10.ID, r10.VEHICLE_REG, r10.CLIENT_NAME, r10.INSTALLATION_DATE, 
           r10.SALES_PERSON, r10.BANK, r10.LOAN_DURATION
    FROM record10 r10
    LEFT JOIN received_payment rp ON r10.VEHICLE_REG = rp.vehicle_reg
    WHERE r10.ID >= ? AND rp.vehicle_reg IS NULL
";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $start_id);
$stmt->execute();
$unpaid_result = $stmt->get_result();

// Check for query errors
if ($stmt->error) {
    die("Error executing query: " . $stmt->error);
}

// Prepare and execute the query for bank summary
$bank_summary_query = "
    SELECT BANK, COUNT(*) AS COUNT
    FROM record10
    WHERE ID >= ? AND ID IN (
        SELECT DISTINCT r10.ID
        FROM record10 r10
        LEFT JOIN received_payment rp ON r10.VEHICLE_REG = rp.vehicle_reg
        WHERE rp.vehicle_reg IS NULL
    )
    GROUP BY BANK
";

$bank_summary_stmt = $conn->prepare($bank_summary_query);
$bank_summary_stmt->bind_param("i", $start_id);
$bank_summary_stmt->execute();
$bank_summary_result = $bank_summary_stmt->get_result();

// Prepare and execute the query for sales person summary
$sales_person_summary_query = "
    SELECT SALES_PERSON, COUNT(*) AS COUNT
    FROM record10
    WHERE ID >= ? AND ID IN (
        SELECT DISTINCT r10.ID
        FROM record10 r10
        LEFT JOIN received_payment rp ON r10.VEHICLE_REG = rp.vehicle_reg
        WHERE rp.vehicle_reg IS NULL
    )
    GROUP BY SALES_PERSON
";

$sales_person_summary_stmt = $conn->prepare($sales_person_summary_query);
$sales_person_summary_stmt->bind_param("i", $start_id);
$sales_person_summary_stmt->execute();
$sales_person_summary_result = $sales_person_summary_stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unpaid Installations</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            background-color: #f0f8ff; /* Light blue background */
            color: #333; /* Dark text color for readability */
            padding: 20px;
        }
        .container {
            max-width: 100vw; /* Full viewport width */
            margin: auto;
            background-color: #b3cde0; /* Light blue background for the container */
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            color: #333; /* Ensure text is readable on light blue background */
        }
        .btn-back {
            background-color: #0066cc; /* Darker blue color for button */
            color: white;
            border-radius: 5px;
            padding: 10px 20px;
            text-decoration: none;
            display: inline-block;
            margin-bottom: 20px;
            font-size: 16px;
        }
        .btn-back:hover {
            background-color: #004d99; /* Even darker blue for hover */
        }
        .table-container {
            overflow-x: auto; /* Enable horizontal scrolling */
            margin-bottom: 20px;
        }
        table {
            width: 100%; /* Full width of its container */
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid #0066cc; /* Darker blue border */
        }
        th, td {
            padding: 10px;
            text-align: left;
            color: #333; /* Dark text color for readability */
        }
        th {
            background-color: #cce5ff; /* Light blue background for headers */
        }
        tr:nth-child(even) {
            background-color: #e6f0ff; /* Very light blue for alternate rows */
        }
        @media (max-width: 768px) {
            body {
                font-size: 14px;
            }
            .container {
                padding: 10px;
            }
            .btn-back {
                font-size: 14px;
                padding: 8px 15px;
            }
            th, td {
                padding: 8px;
            }
        }
        @media (max-width: 576px) {
            body {
                font-size: 12px;
            }
            .container {
                padding: 5px;
            }
            .btn-back {
                font-size: 12px;
                padding: 5px 10px;
            }
            th, td {
                padding: 6px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="dashboard.php" class="btn-back"><i class="fas fa-home"></i> Return to Dashboard</a>
        <h2 class="text-center">Unpaid Installations Summary</h2>

        <?php if ($unpaid_result->num_rows > 0): ?>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Vehicle Registration</th>
                            <th>Client Name</th>
                            <th>Installation Date</th>
                            <th>Sales Person</th>
                            <th>Bank</th>
                            <th>Loan Duration</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $unpaid_result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['ID']); ?></td>
                                <td><?php echo htmlspecialchars($row['VEHICLE_REG']); ?></td>
                                <td><?php echo htmlspecialchars($row['CLIENT_NAME']); ?></td>
                                <td><?php echo htmlspecialchars($row['INSTALLATION_DATE']); ?></td>
                                <td><?php echo htmlspecialchars($row['SALES_PERSON']); ?></td>
                                <td><?php echo htmlspecialchars($row['BANK']); ?></td>
                                <td><?php echo htmlspecialchars($row['LOAN_DURATION']); ?></td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="text-center">No unpaid installations found.</p>
        <?php endif; ?>

        <h3 class="text-center">Bank Summary</h3>
        <?php if ($bank_summary_result->num_rows > 0): ?>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Bank</th>
                            <th>Count</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $bank_summary_result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['BANK']); ?></td>
                                <td><?php echo htmlspecialchars($row['COUNT']); ?></td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="text-center">No bank summary available.</p>
        <?php endif; ?>

        <h3 class="text-center">Sales Person Summary</h3>
        <?php if ($sales_person_summary_result->num_rows > 0): ?>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Sales Person</th>
                            <th>Count</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $sales_person_summary_result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['SALES_PERSON']); ?></td>
                                <td><?php echo htmlspecialchars($row['COUNT']); ?></td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p class="text-center">No sales person summary available.</p>
        <?php endif; ?>

    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>

<?php
$stmt->close();
$bank_summary_stmt->close();
$sales_person_summary_stmt->close();
$conn->close();
?>
