<?php
require 'vendor/autoload.php';

use setasign\Fpdi\Fpdi;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve user input
    $registration = $_POST['registration'];
    $chassis = $_POST['chassis'];
    $engine = $_POST['engine'];
    $model = $_POST['model'];
    $date = $_POST['date'];
    $name = $_POST['name'];
    $color = $_POST['color'];
    $telephone = $_POST['telephone'];
    $systemType = $_POST['systemType'];
    $loanDuration = (int)$_POST['loanDuration'];
    $startDate = new DateTime($_POST['startDate']);
    $endDate = (clone $startDate)->add(new DateInterval("P{$loanDuration}Y"));

    // Format dates
    $formattedStartDate = $startDate->format('Y/m/d');
    $formattedEndDate = $endDate->format('Y/m/d');

    // Load the template
    $templateFile = 'templates/withoutchasis.pdf';
    $serialFile = 'serial_number.txt';

    try {
        // Check if the file exists
        if (!file_exists($templateFile)) {
            throw new Exception("File not found: " . $templateFile);
        }

        // Read the last serial number
        if (file_exists($serialFile)) {
            $serialNumber = (int) file_get_contents($serialFile);
        } else {
            $serialNumber = 0; // Start from 0 if the file doesn't exist
        }

        // Increment the serial number
        $serialNumber++;

        // Store the updated serial number back to the file
        file_put_contents($serialFile, $serialNumber);

        // Create a new FPDI instance
        $pdf = new Fpdi();
        $pdf->AddPage();

        // Import the template
        $pdf->SetSourceFile($templateFile);
        $template = $pdf->ImportPage(1);
        $pdf->UseTemplate($template);

        // Get page dimensions
        $pageWidth = $pdf->GetPageWidth();
        $pageHeight = $pdf->GetPageHeight();

        // Calculate starting Y position (30% of the page height)
        $startY = 0.25 * $pageHeight;

        // Set font and position for adding content
        $pdf->SetFont('Helvetica', '', 9);

        // Define starting Y position and X position for fields
        $xPosition = 10;
        $yPosition = $startY;
        $fieldWidth = $pageWidth - 20; // Adjust width based on page width

        // Add the system type statement above the registration field with adjusted X position
        $pdf->SetFont('Helvetica', 'B', 9); // Bold font and slightly larger size
        $systemTypeX = 10; // Adjust X position here
        $systemTypeY = $startY - 15; // Position above the registration field
        $pdf->SetXY($systemTypeX, $systemTypeY);
        $pdf->MultiCell(0, 5, "This Certificate confirms that the vehicle has been fitted with " . $systemType, 0, 'L');

        // Add bottom margin
        $bottomMargin = 5; // Adjust margin size as needed
        $pdf->Ln($bottomMargin); // Adds space below the system type statement

        // Add padding below the system type statement
        $pdf->Ln(3); // Adds bottom padding

        // Add the serial number at its original x position
        $pdf->SetFont('Arial', '', 12); // Normal font without bold and size 12
        $customX = 160; // Set your desired x-coordinate here
        $pdf->SetXY($customX, 11); // Adjust x to your preferred position
        $pdf->Cell(0, 5, '' . $serialNumber, 0, 1, 'L'); // 'L' aligns the text to the left

        // Function to add text fields next to each other
        function addCompactFields($pdf, $x, &$y, $label, $text, $pageWidth) {
            $labelWidth = 60; // Adjust label width
            $pdf->SetXY($x, $y);
            $pdf->Cell($labelWidth, 10, $label, 0, 0, 'L'); // Print label without line break

            $fieldX = $x + $labelWidth; // Position for the field after the label
            $remainingWidth = $pageWidth - $fieldX - 10; // Remaining width for the field with margin
            $pdf->SetXY($fieldX, $y);
            $pdf->MultiCell($remainingWidth, 10, $text, 0, 'L'); // Adjust height to fit text

            $y += 12; // Move Y position down
        }

        // Add fields to the PDF with compact layout
        $yPosition = $systemTypeY + 10; // Start below the system type statement
        addCompactFields($pdf, $xPosition, $yPosition, 'Registration:', $registration, $pageWidth);
        addCompactFields($pdf, $xPosition, $yPosition, 'Chassis:', $chassis, $pageWidth);
        addCompactFields($pdf, $xPosition, $yPosition, 'Engine:', $engine, $pageWidth);
        addCompactFields($pdf, $xPosition, $yPosition, 'Model:', $model, $pageWidth);
        addCompactFields($pdf, $xPosition, $yPosition, 'Date:', $date, $pageWidth);
        addCompactFields($pdf, $xPosition, $yPosition, 'Name:', $name, $pageWidth);
        addCompactFields($pdf, $xPosition, $yPosition, 'Color:', $color, $pageWidth);
        addCompactFields($pdf, $xPosition, $yPosition, 'Telephone:', $telephone, $pageWidth);

        // Adjust Y position to be right after the telephone field
        $yPosition += 5; // Space after the last field

        // Add the validity statement below the fields and make it bold
        $pdf->SetFont('Helvetica', 'B', 8); // Set font to bold for the validity statement
        $validityStatement = "The Validity of this certificate is for the loan duration {$loanDuration} year(s) from {$formattedStartDate} to {$formattedEndDate}";
        $pdf->SetXY($xPosition, $yPosition);

        // Add the validity statement with a height for MultiCell
        $pdf->MultiCell(0, 10, $validityStatement, 0, 'L'); // Height of 10 for better readability

        // Output the PDF
        $pdf->Output('D', 'filled_template.pdf'); // 'D' for download
        exit; // Prevent further output

    } catch (Exception $e) {
        echo 'Error: ' . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Fill PDF Template</title>
    <style>
        form {
            display: flex;
            flex-direction: column;
            width: 600px;
            margin: 0 auto;
        }
        .form-group {
            display: flex;
            align-items: center;
            margin-bottom: 8px; /* Reduced gap */
        }
        label {
            width: 150px; /* Adjust as needed */
            margin-right: 5px; /* Reduced margin */
            font-weight: bold;
            text-align: right;
        }
        label::after {
            content: " :"; /* Add space before the colon */
            display: inline-block;
            margin-left: 5px; /* Additional spacing if needed */
        }
        input[type="text"], input[type="date"], select {
            flex: 1;
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        input[type="submit"] {
            padding: 10px;
            border: none;
            border-radius: 4px;
            background-color: #4CAF50;
            color: white;
            cursor: pointer;
        }
        input[type="submit"]:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <form action="" method="post">
        <div class="form-group">
            <label for="systemType">System Type</label>
            <select id="systemType" name="systemType" required>
                <option value="GPS">GPS</option>
                <option value="Tracking">Tracking</option>
            </select>
        </div>
        <div class="form-group">
            <label for="registration">Registration</label>
            <input type="text" id="registration" name="registration" required>
        </div>
        <div class="form-group">
            <label for="chassis">Chassis</label>
            <input type="text" id="chassis" name="chassis">
        </div>
        <div class="form-group">
            <label for="engine">Engine</label>
            <input type="text" id="engine" name="engine">
        </div>
        <div class="form-group">
            <label for="model">Model</label>
            <input type="text" id="model" name="model" required>
        </div>
        <div class="form-group">
            <label for="date">Date</label>
            <input type="date" id="date" name="date" required>
        </div>
        <div class="form-group">
            <label for="name">Name</label>
            <input type="text" id="name" name="name">
        </div>
        <div class="form-group">
            <label for="color">Color</label>
            <input type="text" id="color" name="color">
        </div>
        <div class="form-group">
            <label for="telephone">Telephone</label>
            <input type="text" id="telephone" name="telephone">
        </div>
        <div class="form-group">
            <label for="loanDuration">Loan Duration (years)</label>
            <input type="text" id="loanDuration" name="loanDuration" required>
        </div>
        <div class="form-group">
            <label for="startDate">Start Date</label>
            <input type="date" id="startDate" name="startDate" required>
        </div>
        <div class="form-group">
            <label for="endDate">End Date</label>
            <input type="date" id="endDate" name="endDate">
        </div>
        <input type="submit" value="Generate PDF">
    </form>
</body>
</html>
