<?php
// Include database connection
include 'conn.php';

// Set default filter values
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'today';
$technicianFilter = isset($_GET['technician']) ? $_GET['technician'] : '';

// Prepare dates for query
$today = date('Y-m-d'); // Current date in yyyy-mm-dd format
$startOfMonth = date('Y-m-01');
$endOfMonth = date('Y-m-t');
$startOfWeek = date('Y-m-d', strtotime('monday this week'));
$endOfWeek = date('Y-m-d', strtotime('sunday this week'));

// Define the SQL query based on the filters
$sql = "SELECT * FROM checkups WHERE 1=1";
if ($filter == 'week') {
    $sql .= " AND STR_TO_DATE(`DATE`, '%Y-%m-%d') BETWEEN '$startOfWeek' AND '$endOfWeek'";
} elseif ($filter == 'month') {
    $sql .= " AND STR_TO_DATE(`DATE`, '%Y-%m-%d') BETWEEN '$startOfMonth' AND '$endOfMonth'";
} else {
    $sql .= " AND STR_TO_DATE(`DATE`, '%Y-%m-%d') = '$today'";
}

if (!empty($technicianFilter)) {
    $sql .= " AND TECHNICIAN = '" . $conn->real_escape_string($technicianFilter) . "'";
}

// Execute the query
$result = $conn->query($sql);

// Check for query execution errors
if ($conn->error) {
    echo "Query Error: " . $conn->error . "<br>";
}

// Get the number of records found
$recordCount = $result ? $result->num_rows : 0;

// Fetch list of technicians for the filter dropdown
$techniciansResult = $conn->query("SELECT DISTINCT TECHNICIAN FROM checkups");
$technicians = [];
if ($techniciansResult && $techniciansResult->num_rows > 0) {
    while ($techRow = $techniciansResult->fetch_assoc()) {
        $technicians[] = $techRow['TECHNICIAN'];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checkups</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 20px;
            background-color: #f5f5f5;
            color: #333;
        }
        h1 {
            color: #4CAF50;
            border-bottom: 2px solid #4CAF50;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        form {
            margin-bottom: 20px;
            padding: 15px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            gap: 10px;
        }
        .form-group {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        select, button {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 1em;
        }
        button {
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        .return-btn {
            background-color: #2196F3;
            color: white;
            border: none;
            border-radius: 5px;
            padding: 10px 20px;
            text-decoration: none;
            display: inline-block;
            margin-bottom: 20px;
        }
        .return-btn:hover {
            background-color: #1976D2;
        }
        p {
            font-size: 1.1em;
            color: #555;
        }
        .table-container {
            overflow-x: auto;
            margin-top: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 12px;
            text-align: left;
        }
        th {
            background-color: #4CAF50;
            color: white;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #e2f4e2;
        }
        @media (max-width: 600px) {
            th, td {
                padding: 8px;
            }
        }
    </style>
</head>
<body>
    <a href="dashboard.php" class="return-btn">Return to Dashboard</a>
    <h1>Checkups</h1>
    <form method="get" action="">
        <div class="form-group">
            <label for="filter">Filter by:</label>
            <select name="filter" id="filter">
                <option value="today" <?php if ($filter == 'today') echo 'selected'; ?>>Today</option>
                <option value="week" <?php if ($filter == 'week') echo 'selected'; ?>>This Week</option>
                <option value="month" <?php if ($filter == 'month') echo 'selected'; ?>>This Month</option>
            </select>
        </div>
        <div class="form-group">
            <label for="technician">Technician:</label>
            <select name="technician" id="technician">
                <option value="">All Technicians</option>
                <?php foreach ($technicians as $technician): ?>
                    <option value="<?php echo htmlspecialchars($technician); ?>" <?php if ($technicianFilter == $technician) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($technician); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit">Apply Filter</button>
    </form>

    <p><strong>Number of records found:</strong> <?php echo $recordCount; ?></p>

    <div class="table-container">
        <table>
            <thead>
                <tr>
              
                    <th>Assigned By</th>
                    <th>Date</th>
                    <th>Technician</th>
                    <th>Reg No</th>
                    <th>Revenue</th>
                    <th>Cost</th>
                    <th>Status Comment</th>
                    <th>Paid</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result && $recordCount > 0) {
                    while($row = $result->fetch_assoc()) {
                        $displayDate = $row['DATE']; // Assuming the date is already in mm/dd/yyyy format for display
                        echo "<tr>
                     
                            <td>{$row['Assigned_by']}</td>
                            <td>{$displayDate}</td>
                            <td>{$row['TECHNICIAN']}</td>
                            <td>{$row['REG_NO']}</td>
                            <td>{$row['REVENUE']}</td>
                            <td>{$row['COST']}</td>
                            <td>{$row['STATUS_COMMENT']}</td>
                            <td>{$row['Paid']}</td>
                        </tr>";
                    }
                } else {
                    echo "<tr><td colspan='9'>No records found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <?php $conn->close(); ?>
</body>
</html>
