<?php
// Include database connection
include 'conn.php';

// Set default filter values
$dateFilter = isset($_GET['date']) ? $_GET['date'] : '';
$salesPersonFilter = isset($_GET['sales_person']) ? $_GET['sales_person'] : '';
$technicianFilter = isset($_GET['technician']) ? $_GET['technician'] : '';
$rangeFilter = isset($_GET['range']) ? $_GET['range'] : '';

// Function to convert date format from mm/dd/yyyy to yyyy-mm-dd
function convertDateFormat($date) {
    $parts = explode('/', $date);
    return "{$parts[2]}-{$parts[0]}-{$parts[1]}";
}

// Function to convert date format from yyyy-mm-dd to mm/dd/yyyy
function convertDateFormatToDisplay($date) {
    $parts = explode('-', $date);
    return "{$parts[1]}/{$parts[2]}/{$parts[0]}";
}

// Prepare date ranges based on filter
switch($rangeFilter) {
    case 'today':
        $startDate = $endDate = date('Y-m-d');
        break;
    case 'week':
        $startDate = date('Y-m-d', strtotime('monday this week'));
        $endDate = date('Y-m-d', strtotime('sunday this week'));
        break;
    case 'month':
        $startDate = date('Y-m-01');
        $endDate = date('Y-m-t');
        break;
    case 'year':
        $startDate = date('Y-01-01');
        $endDate = date('Y-12-31');
        break;
    default:
        $startDate = $endDate = '';
        break;
}

// Convert dates to mm/dd/yyyy for the query
if (!empty($startDate)) {
    $startDate = convertDateFormatToDisplay($startDate);
}
if (!empty($endDate)) {
    $endDate = convertDateFormatToDisplay($endDate);
}

// Define the SQL query based on the filters
$sql = "SELECT * FROM record10 WHERE 1=1";
if (!empty($dateFilter)) {
    $dateFilter = convertDateFormat($dateFilter);
    $sql .= " AND INSTALLATION_DATE = '" . $conn->real_escape_string($dateFilter) . "'";
} elseif (!empty($startDate) && !empty($endDate)) {
    $sql .= " AND INSTALLATION_DATE BETWEEN '" . $conn->real_escape_string(convertDateFormat($startDate)) . "' AND '" . $conn->real_escape_string(convertDateFormat($endDate)) . "'";
}
if (!empty($salesPersonFilter)) {
    $sql .= " AND SALES_PERSON = '" . $conn->real_escape_string($salesPersonFilter) . "'";
}
if (!empty($technicianFilter)) {
    $sql .= " AND TECHNICIAN = '" . $conn->real_escape_string($technicianFilter) . "'";
}

// Execute the query
$result = $conn->query($sql);

// Check for query execution errors
if ($conn->error) {
    echo "Query Error: " . $conn->error . "<br>";
}

// Get the number of records found
$recordCount = $result ? $result->num_rows : 0;

// Fetch list of dates, sales persons, and technicians for the filter dropdowns
$datesResult = $conn->query("SELECT DISTINCT INSTALLATION_DATE FROM record10");
$salesPersonsResult = $conn->query("SELECT DISTINCT SALES_PERSON FROM record10");
$techniciansResult = $conn->query("SELECT DISTINCT TECHNICIAN FROM record10");

$dates = [];
$salesPersons = [];
$technicians = [];

if ($datesResult && $datesResult->num_rows > 0) {
    while ($dateRow = $datesResult->fetch_assoc()) {
        $dates[] = convertDateFormatToDisplay($dateRow['INSTALLATION_DATE']);
    }
}
if ($salesPersonsResult && $salesPersonsResult->num_rows > 0) {
    while ($salesRow = $salesPersonsResult->fetch_assoc()) {
        $salesPersons[] = $salesRow['SALES_PERSON'];
    }
}
if ($techniciansResult && $techniciansResult->num_rows > 0) {
    while ($techRow = $techniciansResult->fetch_assoc()) {
        $technicians[] = $techRow['TECHNICIAN'];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Record Filter</title>
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/smoothness/jquery-ui.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f5f5f5;
        }
        h1 {
            color: #4CAF50;
            border-bottom: 2px solid #4CAF50;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        form {
            margin-bottom: 20px;
            padding: 15px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
        }
        .form-group {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        select, input, button {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 1em;
        }
        button {
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        .return-btn {
            background-color: #2196F3;
            color: white;
            border: none;
            border-radius: 5px;
            padding: 10px 20px;
            text-decoration: none;
            display: inline-block;
            margin-bottom: 20px;
        }
        .return-btn:hover {
            background-color: #1976D2;
        }
        p {
            font-size: 1.1em;
            color: #555;
        }
        .table-container {
            overflow-x: auto;
            margin-top: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 12px;
            text-align: left;
        }
        th {
            background-color: #4CAF50;
            color: white;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #e2f4e2;
        }
        @media (max-width: 600px) {
            th, td {
                padding: 8px;
            }
        }
    </style>
</head>
<body>
    <a href="dashboard.php" class="return-btn">Return to Dashboard</a>
    <h1>Filter Records</h1>
    <form method="get" action="">
        <div class="form-group">
            <label for="date">Date:</label>
            <input type="text" id="date" name="date" value="<?php echo htmlspecialchars($dateFilter); ?>" placeholder="Select date">
        </div>
        <div class="form-group">
            <label for="range">Range:</label>
            <select name="range" id="range">
                <option value="">All Time</option>
                <option value="today" <?php if ($rangeFilter == 'today') echo 'selected'; ?>>Today</option>
                <option value="week" <?php if ($rangeFilter == 'week') echo 'selected'; ?>>This Week</option>
                <option value="month" <?php if ($rangeFilter == 'month') echo 'selected'; ?>>This Month</option>
                <option value="year" <?php if ($rangeFilter == 'year') echo 'selected'; ?>>This Year</option>
            </select>
        </div>
        <div class="form-group">
            <label for="sales_person">Sales Person:</label>
            <select name="sales_person" id="sales_person">
                <option value="">All Sales Persons</option>
                <?php foreach ($salesPersons as $salesPerson): ?>
                    <option value="<?php echo htmlspecialchars($salesPerson); ?>" <?php if ($salesPersonFilter == $salesPerson) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($salesPerson); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label for="technician">Technician:</label>
            <select name="technician" id="technician">
                <option value="">All Technicians</option>
                <?php foreach ($technicians as $technician): ?>
                    <option value="<?php echo htmlspecialchars($technician); ?>" <?php if ($technicianFilter == $technician) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($technician); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit">Apply Filters</button>
    </form>

    <p>Number of records found: <?php echo $recordCount; ?></p>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Installation Date</th>
                    <th>Client Name</th>
                    <th>Sales Person</th>
                    <th>Vehicle Reg</th>
                    <th>Model</th>
                    <th>Tracker Number</th>
                    <th>Contact</th>
                    <th>Bank</th>
                    <th>Technician</th>
                    <th>T_K</th>
                    <th>Tracksolid</th>
                    <th>Username</th>
                    <th>Password</th>
                    <th>Loan Duration</th>
                    <th>C_NO</th>
                    <th>Expiry</th>
                    <th>Paid Status</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result && $recordCount > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>
                            <td>{$row['ID']}</td>
                            <td>{$row['INSTALLATION_DATE']}</td>
                            <td>{$row['CLIENT_NAME']}</td>
                            <td>{$row['SALES_PERSON']}</td>
                            <td>{$row['VEHICLE_REG']}</td>
                            <td>{$row['MODEL']}</td>
                            <td>{$row['TRACKER_NUMBER']}</td>
                            <td>{$row['CONTACT']}</td>
                            <td>{$row['Bank']}</td>
                            <td>{$row['TECHNICIAN']}</td>
                            <td>{$row['T_K']}</td>
                            <td>{$row['Tracksolid']}</td>
                            <td>{$row['USERNAME']}</td>
                            <td>{$row['PASSWORD']}</td>
                            <td>{$row['LOAN_DURATION']}</td>
                            <td>{$row['C_NO']}</td>
                            <td>{$row['expiray']}</td>
                            <td>{$row['paid_status']}</td>
                        </tr>";
                    }
                } else {
                    echo "<tr><td colspan='17'>No records found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <?php $conn->close(); ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script>
        $(function() {
            $("#date").datepicker({
                dateFormat: "mm/dd/yy",
                changeMonth: true,
                changeYear: true
            });
        });
    </script>
</body>
</html>
