<!DOCTYPE html>
<html>
<head>
    <title>CSV Import Form</title>
</head>
<body>
    <h2>Import CSV into MySQL</h2>
    <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" enctype="multipart/form-data">
        Select CSV file to upload:
        <input type="file" name="file" id="file">
        <input type="submit" value="Upload CSV" name="submit">
    </form>

    <?php
    // Database connection parameters
    $servername = "localhost";
    $username = "root";
    $password = "";
    $database = "installationrecord"; // Replace with your database name

    // Check if form is submitted
    if (isset($_POST['submit'])) {
        // Create connection
        $conn = new mysqli($servername, $username, $password, $database);

        // Check connection
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // Function to clean and validate data before insertion
        function cleanData($data) {
            global $conn;
            // Use real_escape_string or other validation methods as needed
            return $conn->real_escape_string($data);
        }

        // Check if file was uploaded without errors
        if (isset($_FILES["file"]) && $_FILES["file"]["error"] == 0) {
            $filename = $_FILES["file"]["tmp_name"];

            // Process each batch (e.g., 1000 rows per batch)
            $batchSize = 1000; // Adjust batch size as needed
            $row = 1; // Starting row number

            if (($handle = fopen($filename, "r")) !== false) {
                $header = fgetcsv($handle, 1000, ","); // Skip header row

                // Initialize batch insert query
                $sqlBase = "INSERT INTO record2 (INSTALLATION_DATE, CLIENT_NAME, SALES_PERSON, VEHICLE_REG, MODEL, TRACKER_NUMBER, CONTACT, Finacia, TECHNICIAN, T_K, Tracksolid, USERNAME, PASSWORD, LOAN_DURATION, C_NO) VALUES ";

                $sqlValues = array();
                $rowCount = 0;

                while (($data = fgetcsv($handle, 1000, ",")) !== false) {
                    // Clean and prepare data for insertion
                    $installation_date = cleanData($data[0]);
                    $client_name = cleanData($data[1]);
                    $sales_person = cleanData($data[2]);
                    $vehicle_reg = cleanData($data[3]);
                    $model = cleanData($data[4]);
                    $tracker_number = cleanData($data[5]);
                    $contact = cleanData($data[6]);
                    $finacia = cleanData($data[7]);
                    $technician = cleanData($data[8]);
                    $t_k = cleanData($data[9]);
                    $tracksolid = cleanData($data[10]);
                    $username = cleanData($data[11]);
                    $password = cleanData($data[12]);
                    $loan_duration = intval(cleanData($data[13]));
                    $c_no = cleanData($data[14]);

                    // Prepare values for batch insert
                    $sqlValues[] = "('$installation_date', '$client_name', '$sales_person', '$vehicle_reg', '$model', '$tracker_number', '$contact', '$finacia', '$technician', '$t_k', '$tracksolid', '$username', '$password', $loan_duration, '$c_no')";
                    $rowCount++;

                    // Execute batch insert when batch size is reached
                    if ($rowCount % $batchSize == 0) {
                        $sql = $sqlBase . implode(", ", $sqlValues);
                        if ($conn->query($sql) !== true) {
                            echo "Error: " . $sql . "<br>" . $conn->error;
                        }
                        $sqlValues = array(); // Reset batch values
                    }
                }

                // Insert any remaining rows
                if (!empty($sqlValues)) {
                    $sql = $sqlBase . implode(", ", $sqlValues);
                    if ($conn->query($sql) !== true) {
                        echo "Error: " . $sql . "<br>" . $conn->error;
                    }
                }

                fclose($handle);
                echo "CSV data imported successfully!";
            } else {
                echo "Error opening file";
            }
        } else {
            echo "Error uploading file";
        }

        // Close MySQL connection
        $conn->close();
    }
    ?>
</body>
</html>
